/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.channel;

import com.twitter.finagle.Failure;
import com.twitter.finagle.netty4.channel.ChannelStatsHandler$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.Gauge;
import com.twitter.finagle.stats.Stat;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.stats.Verbosity$;
import com.twitter.util.Duration;
import com.twitter.util.Monitor$;
import com.twitter.util.Stopwatch$;
import com.twitter.util.TimeLike;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.timeout.TimeoutException;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Level;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t%r!B\u0001\u0003\u0011\u0013i\u0011aE\"iC:tW\r\\*uCR\u001c\b*\u00198eY\u0016\u0014(BA\u0002\u0005\u0003\u001d\u0019\u0007.\u00198oK2T!!\u0002\u0004\u0002\r9,G\u000f^=5\u0015\t9\u0001\"A\u0004gS:\fw\r\\3\u000b\u0005%Q\u0011a\u0002;xSR$XM\u001d\u0006\u0002\u0017\u0005\u00191m\\7\u0004\u0001A\u0011abD\u0007\u0002\u0005\u0019)\u0001C\u0001E\u0005#\t\u00192\t[1o]\u0016d7\u000b^1ug\"\u000bg\u000e\u001a7feN\u0011qB\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\t\u000beyA\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005i\u0001b\u0002\u000f\u0010\u0005\u0004%I!H\u0001\u0004Y><W#\u0001\u0010\u0011\u0005}1S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013a\u00027pO\u001eLgn\u001a\u0006\u0003G\u0011\nA!\u001e;jY*\tQ%\u0001\u0003kCZ\f\u0017BA\u0014!\u0005\u0019aunZ4fe\"1\u0011f\u0004Q\u0001\ny\tA\u0001\\8hA\u0019!1f\u0004\u0001-\u0005I\u0019\u0006.\u0019:fI\u000eC\u0017M\u001c8fYN#\u0018\r^:\u0014\u0005)\u0012\u0002\u0002\u0003\u0018+\u0005\u0003\u0005\u000b\u0011B\u0018\u0002\u001bM$\u0018\r^:SK\u000e,\u0017N^3s!\t\u00014'D\u00012\u0015\t\u0011d!A\u0003ti\u0006$8/\u0003\u00025c\ti1\u000b^1ugJ+7-Z5wKJDQ!\u0007\u0016\u0005\u0002Y\"\"aN\u001d\u0011\u0005aRS\"A\b\t\u000b9*\u0004\u0019A\u0018\t\u000fmR#\u0019!C\u0005y\u0005y1m\u001c8oK\u000e$\u0018n\u001c8D_VtG/F\u0001>!\tq4)D\u0001@\u0015\t\u0001\u0015)\u0001\u0004bi>l\u0017n\u0019\u0006\u0003\u0005\n\n!bY8oGV\u0014(/\u001a8u\u0013\t!uHA\u0005M_:<\u0017\t\u001a3fe\"1aI\u000bQ\u0001\nu\n\u0001cY8o]\u0016\u001cG/[8o\u0007>,h\u000e\u001e\u0011\t\u000b!SC\u0011A%\u00021\r|gN\\3di&|gnQ8v]RLen\u0019:f[\u0016tG\u000fF\u0001K!\t\u00192*\u0003\u0002M)\t!QK\\5u\u0011\u0015q%\u0006\"\u0001J\u0003a\u0019wN\u001c8fGRLwN\\\"pk:$H)Z2sK6,g\u000e\u001e\u0005\b!*\u0012\r\u0011\"\u0003=\u0003I!Hn]\"p]:,7\r^5p]\u000e{WO\u001c;\t\rIS\u0003\u0015!\u0003>\u0003M!Hn]\"p]:,7\r^5p]\u000e{WO\u001c;!\u0011\u0015!&\u0006\"\u0001J\u0003m!Hn]\"p]:,7\r^5p]\u000e{WO\u001c;J]\u000e\u0014X-\\3oi\")aK\u000bC\u0001\u0013\u0006YB\u000f\\:D_:tWm\u0019;j_:\u001cu.\u001e8u\t\u0016\u001c'/Z7f]RDq\u0001\u0017\u0016C\u0002\u0013\u0005\u0011,\u0001\u0005d_:tWm\u0019;t+\u0005Q\u0006C\u0001\u0019\\\u0013\ta\u0016GA\u0004D_VtG/\u001a:\t\ryS\u0003\u0015!\u0003[\u0003%\u0019wN\u001c8fGR\u001c\b\u0005C\u0004aU\t\u0007I\u0011A1\u0002%\r|gN\\3di&|g\u000eR;sCRLwN\\\u000b\u0002EB\u0011\u0001gY\u0005\u0003IF\u0012Aa\u0015;bi\"1aM\u000bQ\u0001\n\t\f1cY8o]\u0016\u001cG/[8o\tV\u0014\u0018\r^5p]\u0002Bq\u0001\u001b\u0016C\u0002\u0013\u0005\u0011-A\fd_:tWm\u0019;j_:\u0014VmY3jm\u0016$')\u001f;fg\"1!N\u000bQ\u0001\n\t\f\u0001dY8o]\u0016\u001cG/[8o%\u0016\u001cW-\u001b<fI\nKH/Z:!\u0011\u001da'F1A\u0005\u0002\u0005\f1cY8o]\u0016\u001cG/[8o'\u0016tGOQ=uKNDaA\u001c\u0016!\u0002\u0013\u0011\u0017\u0001F2p]:,7\r^5p]N+g\u000e\u001e\"zi\u0016\u001c\b\u0005C\u0004qU\t\u0007I\u0011A-\u0002\u0011]\u0014\u0018\u000e^1cY\u0016DaA\u001d\u0016!\u0002\u0013Q\u0016!C<sSR\f'\r\\3!\u0011\u001d!(F1A\u0005\u0002e\u000b!\"\u001e8xe&$\u0018M\u00197f\u0011\u00191(\u0006)A\u00055\u0006YQO\\<sSR\f'\r\\3!\u0011\u001dA(F1A\u0005\u0002e\u000bQB]3dK&4X\r\u001a\"zi\u0016\u001c\bB\u0002>+A\u0003%!,\u0001\bsK\u000e,\u0017N^3e\u0005f$Xm\u001d\u0011\t\u000fqT#\u0019!C\u00013\u0006I1/\u001a8u\u0005f$Xm\u001d\u0005\u0007}*\u0002\u000b\u0011\u0002.\u0002\u0015M,g\u000e\u001e\"zi\u0016\u001c\b\u0005C\u0005\u0002\u0002)\u0012\r\u0011\"\u0001\u0002\u0004\u0005QQ\r_2faRLwN\\:\u0016\u0003=Bq!a\u0002+A\u0003%q&A\u0006fq\u000e,\u0007\u000f^5p]N\u0004\u0003\u0002CA\u0006U\t\u0007I\u0011A-\u0002\u0017\rdwn]3t\u0007>,h\u000e\u001e\u0005\b\u0003\u001fQ\u0003\u0015!\u0003[\u00031\u0019Gn\\:fg\u000e{WO\u001c;!\u0011%\t\u0019B\u000bb\u0001\n\u0013\t)\"A\u0006d_:tWm\u0019;j_:\u001cXCAA\f!\r\u0001\u0014\u0011D\u0005\u0004\u00037\t$!B$bk\u001e,\u0007\u0002CA\u0010U\u0001\u0006I!a\u0006\u0002\u0019\r|gN\\3di&|gn\u001d\u0011\t\u0013\u0005\r\"F1A\u0005\n\u0005U\u0011A\u0004;mg\u000e{gN\\3di&|gn\u001d\u0005\t\u0003OQ\u0003\u0015!\u0003\u0002\u0018\u0005yA\u000f\\:D_:tWm\u0019;j_:\u001c\bEB\u0003\u0011\u0005\u0011\tYc\u0005\u0003\u0002*\u00055\u0002\u0003BA\u0018\u0003wi!!!\r\u000b\u0007\r\t\u0019D\u0003\u0003\u00026\u0005]\u0012!\u00028fiRL(BAA\u001d\u0003\tIw.\u0003\u0003\u0002>\u0005E\"\u0001F\"iC:tW\r\u001c#va2,\u0007\u0010S1oI2,'\u000fC\u0006\u0002B\u0005%\"\u0011!Q\u0001\n\u0005\r\u0013AE:iCJ,Gm\u00115b]:,Gn\u0015;biN\u00042!!\u0012+\u001d\r\t9\u0005\u0001\b\u0005\u0003\u0013\nyF\u0004\u0003\u0002L\u0005uc\u0002BA'\u00037rA!a\u0014\u0002Z9!\u0011\u0011KA,\u001b\t\t\u0019FC\u0002\u0002V1\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002\u0004\t!9\u0011$!\u000b\u0005\u0002\u0005\rD\u0003BA3\u0003O\u00022ADA\u0015\u0011!\t\t%!\u0019A\u0002\u0005\r\u0003\u0002DA6\u0003S\u0001\r\u0011!Q!\n\u00055\u0014\u0001E2iC:tW\r\u001c\"zi\u0016\u001c(+Z1e!\r\u0019\u0012qN\u0005\u0004\u0003c\"\"\u0001\u0002'p]\u001eDA\"!\u001e\u0002*\u0001\u0007\t\u0011)Q\u0005\u0003[\n1c\u00195b]:,GNQ=uKN<&/\u001b;uK:DA\"!\u001f\u0002*\u0001\u0007\t\u0011)Q\u0005\u0003w\n!c\u00195b]:,GnV1t/JLG/\u00192mKB\u00191#! \n\u0007\u0005}DCA\u0004C_>dW-\u00198\t\u0019\u0005\r\u0015\u0011\u0006a\u0001\u0002\u0003\u0006K!!\"\u0002/\rD\u0017M\u001c8fY^\u0013\u0018\u000e^1cY\u0016$UO]1uS>t\u0007\u0003BAD\u0003#sA!!#\u0002\u000e6\u0011\u00111\u0012\u0006\u0003G!IA!a$\u0002\f\u0006I1\u000b^8qo\u0006$8\r[\u0005\u0005\u0003'\u000b)JA\u0004FY\u0006\u00048/\u001a3\n\t\u0005]\u00151\u0012\u0002\n'R|\u0007o^1uG\"D1\u0002YA\u0015\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0006\"I\u0011QTA\u0015A\u0003&\u00111P\u0001\u000eG\"\fgN\\3m\u0003\u000e$\u0018N^3\t\u0013\u0005\u0005\u0016\u0011\u0006Q!\n\u0005m\u0014\u0001\u0005;mg\u000eC\u0017M\u001c8fY\u0006\u001bG/\u001b<f\u0011!\t)+!\u000b\u0005B\u0005\u001d\u0016\u0001\u00045b]\u0012dWM]!eI\u0016$Gc\u0001&\u0002*\"A\u00111VAR\u0001\u0004\ti+A\u0002dib\u0004B!a\f\u00020&!\u0011\u0011WA\u0019\u0005U\u0019\u0005.\u00198oK2D\u0015M\u001c3mKJ\u001cuN\u001c;fqRD\u0001\"!(\u0002*\u0011\u0005\u0013Q\u0017\u000b\u0004\u0015\u0006]\u0006\u0002CAV\u0003g\u0003\r!!,\t\u0011\u0005m\u0016\u0011\u0006C!\u0003{\u000bQa\u001e:ji\u0016$rASA`\u0003\u0003\f\t\u000e\u0003\u0005\u0002,\u0006e\u0006\u0019AAW\u0011!\t\u0019-!/A\u0002\u0005\u0015\u0017aA7tOB!\u0011qYAg\u001b\t\tIMC\u0002\u0002L\u0012\nA\u0001\\1oO&!\u0011qZAe\u0005\u0019y%M[3di\"A\u00111[A]\u0001\u0004\t).A\u0001q!\u0011\ty#a6\n\t\u0005e\u0017\u0011\u0007\u0002\u000f\u0007\"\fgN\\3m!J|W.[:f\u0011!\ti.!\u000b\u0005B\u0005}\u0017aC2iC:tW\r\u001c*fC\u0012$RASAq\u0003GD\u0001\"a+\u0002\\\u0002\u0007\u0011Q\u0016\u0005\t\u0003\u0007\fY\u000e1\u0001\u0002F\"A\u0011q]A\u0015\t\u0003\nI/A\u0003dY>\u001cX\rF\u0003K\u0003W\fi\u000f\u0003\u0005\u0002,\u0006\u0015\b\u0019AAW\u0011!\t\u0019.!:A\u0002\u0005U\u0007\u0002CAy\u0003S!\t%a=\u0002\u001f\rD\u0017M\u001c8fY&s\u0017m\u0019;jm\u0016$2ASA{\u0011!\tY+a<A\u0002\u00055\u0006\u0002CA}\u0003S!\t%a?\u0002\u001f\u0015D8-\u001a9uS>t7)Y;hQR$RASA\u007f\u0003\u007fD\u0001\"a+\u0002x\u0002\u0007\u0011Q\u0016\u0005\t\u0005\u0003\t9\u00101\u0001\u0003\u0004\u0005)1-Y;tKB!!Q\u0001B\b\u001d\u0011\u00119Aa\u0003\u000f\t\u0005E#\u0011B\u0005\u0002+%\u0019!Q\u0002\u000b\u0002\u000fA\f7m[1hK&!!\u0011\u0003B\n\u0005%!\u0006N]8xC\ndWMC\u0002\u0003\u000eQA\u0001Ba\u0006\u0002*\u0011\u0005#\u0011D\u0001\u001aG\"\fgN\\3m/JLG/\u00192jY&$\u0018p\u00115b]\u001e,G\rF\u0002K\u00057A\u0001\"a+\u0003\u0016\u0001\u0007\u0011Q\u0016\u0005\t\u0005?\tI\u0003\"\u0011\u0003\"\u0005\u0011Ro]3s\u000bZ,g\u000e\u001e+sS\u001e<WM]3e)\u0015Q%1\u0005B\u0013\u0011!\tYK!\bA\u0002\u00055\u0006b\u0002B\u0014\u0005;\u0001\rAE\u0001\u0004KZ$\b")
public class ChannelStatsHandler
extends ChannelDuplexHandler {
    private final SharedChannelStats sharedChannelStats;
    private long channelBytesRead;
    private long channelBytesWritten;
    private boolean channelWasWritable;
    private Function0<Duration> channelWritableDuration;
    private Function0<Duration> connectionDuration;
    private boolean channelActive;
    private boolean tlsChannelActive;

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.channelBytesRead = 0L;
        this.channelBytesWritten = 0L;
        this.channelWasWritable = true;
        this.channelWritableDuration = Stopwatch$.MODULE$.start();
        super.handlerAdded(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.sharedChannelStats.connects().incr();
        this.sharedChannelStats.connectionCountIncrement();
        this.channelActive = true;
        this.connectionDuration = Stopwatch$.MODULE$.start();
        super.channelActive(ctx);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise p) {
        Object object = msg;
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            int readableBytes = byteBuf.readableBytes();
            this.sharedChannelStats.sentBytes().incr((long)readableBytes);
            this.channelBytesWritten += (long)readableBytes;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            ChannelStatsHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$log().warning("ChannelStatsHandler received non-ByteBuf write: " + msg);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.write(ctx, msg, p);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Object object = msg;
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            int readableBytes = byteBuf.readableBytes();
            this.sharedChannelStats.receivedBytes().incr((long)readableBytes);
            this.channelBytesRead += (long)readableBytes;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            ChannelStatsHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$log().warning("ChannelStatsHandler received non-ByteBuf read: " + msg);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.channelRead(ctx, msg);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise p) {
        this.sharedChannelStats.closesCount().incr();
        super.close(ctx, p);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.channelActive) {
            this.channelActive = false;
            Function0<Duration> elapsed = this.connectionDuration;
            this.connectionDuration = null;
            this.sharedChannelStats.connectionDuration().add((float)((TimeLike)elapsed.apply()).inMilliseconds());
            this.sharedChannelStats.connectionCountDecrement();
            long oldChannelBytesRead = this.channelBytesRead;
            long oldChannelBytesWritten = this.channelBytesWritten;
            this.channelBytesRead = 0L;
            this.channelBytesWritten = 0L;
            this.sharedChannelStats.connectionReceivedBytes().add((float)oldChannelBytesRead);
            this.sharedChannelStats.connectionSentBytes().add((float)oldChannelBytesWritten);
            if (this.tlsChannelActive) {
                this.tlsChannelActive = false;
                this.sharedChannelStats.tlsConnectionCountDecrement();
            }
        }
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.sharedChannelStats.exceptions().counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{cause.getClass().getName()})).incr();
        if (!Monitor$.MODULE$.isActive()) {
            Level level;
            Throwable throwable = cause;
            if (throwable instanceof IOException) {
                level = Level.FINE;
            } else if (throwable instanceof TimeoutException) {
                level = Level.FINE;
            } else if (throwable instanceof Failure) {
                Failure failure = (Failure)throwable;
                level = failure.logLevel();
            } else {
                level = Level.WARNING;
            }
            Level level2 = level;
            ChannelStatsHandler$.MODULE$.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$log().log(level2, "ChannelStatsHandler caught an exception", cause);
        }
        super.exceptionCaught(ctx, cause);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        boolean isWritable = ctx.channel().isWritable();
        if (isWritable != this.channelWasWritable) {
            Duration elapsed = (Duration)this.channelWritableDuration.apply();
            Counter stat = this.channelWasWritable ? this.sharedChannelStats.writable() : this.sharedChannelStats.unwritable();
            stat.incr((long)((int)elapsed.inMilliseconds()));
            this.channelWasWritable = isWritable;
            this.channelWritableDuration = Stopwatch$.MODULE$.start();
        }
        super.channelWritabilityChanged(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        Object object = evt;
        if (object instanceof SslHandshakeCompletionEvent) {
            BoxedUnit boxedUnit;
            if (this.channelActive) {
                this.tlsChannelActive = true;
                this.sharedChannelStats.tlsConnectionCountIncrement();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.userEventTriggered(ctx, evt);
    }

    public ChannelStatsHandler(SharedChannelStats sharedChannelStats) {
        this.sharedChannelStats = sharedChannelStats;
        this.channelActive = false;
        this.tlsChannelActive = false;
    }

    public static class SharedChannelStats {
        private final LongAdder connectionCount = new LongAdder();
        private final LongAdder tlsConnectionCount = new LongAdder();
        private final Counter connects;
        private final Stat connectionDuration;
        private final Stat connectionReceivedBytes;
        private final Stat connectionSentBytes;
        private final Counter writable;
        private final Counter unwritable;
        private final Counter receivedBytes;
        private final Counter sentBytes;
        private final StatsReceiver exceptions;
        private final Counter closesCount;
        private final Gauge connections;
        private final Gauge tlsConnections;

        private LongAdder connectionCount() {
            return this.connectionCount;
        }

        public void connectionCountIncrement() {
            this.connectionCount().increment();
        }

        public void connectionCountDecrement() {
            this.connectionCount().decrement();
        }

        private LongAdder tlsConnectionCount() {
            return this.tlsConnectionCount;
        }

        public void tlsConnectionCountIncrement() {
            this.tlsConnectionCount().increment();
        }

        public void tlsConnectionCountDecrement() {
            this.tlsConnectionCount().decrement();
        }

        public Counter connects() {
            return this.connects;
        }

        public Stat connectionDuration() {
            return this.connectionDuration;
        }

        public Stat connectionReceivedBytes() {
            return this.connectionReceivedBytes;
        }

        public Stat connectionSentBytes() {
            return this.connectionSentBytes;
        }

        public Counter writable() {
            return this.writable;
        }

        public Counter unwritable() {
            return this.unwritable;
        }

        public Counter receivedBytes() {
            return this.receivedBytes;
        }

        public Counter sentBytes() {
            return this.sentBytes;
        }

        public StatsReceiver exceptions() {
            return this.exceptions;
        }

        public Counter closesCount() {
            return this.closesCount;
        }

        private Gauge connections() {
            return this.connections;
        }

        private Gauge tlsConnections() {
            return this.tlsConnections;
        }

        public SharedChannelStats(StatsReceiver statsReceiver) {
            this.connects = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connects"}));
            this.connectionDuration = statsReceiver.stat(Verbosity$.MODULE$.Debug(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_duration"}));
            this.connectionReceivedBytes = statsReceiver.stat(Verbosity$.MODULE$.Debug(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_received_bytes"}));
            this.connectionSentBytes = statsReceiver.stat(Verbosity$.MODULE$.Debug(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_sent_bytes"}));
            this.writable = statsReceiver.counter(Verbosity$.MODULE$.Debug(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"socket_writable_ms"}));
            this.unwritable = statsReceiver.counter(Verbosity$.MODULE$.Debug(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"socket_unwritable_ms"}));
            this.receivedBytes = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"received_bytes"}));
            this.sentBytes = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sent_bytes"}));
            this.exceptions = statsReceiver.scope("exn");
            this.closesCount = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"closes"}));
            this.connections = statsReceiver.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connections"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> this.connectionCount().sum());
            this.tlsConnections = statsReceiver.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tls", "connections"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> this.tlsConnectionCount().sum());
        }
    }
}

