/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.ssl.server;

import com.twitter.finagle.netty4.ssl.Netty4SslConfigurations$;
import com.twitter.finagle.ssl.ApplicationProtocols;
import com.twitter.finagle.ssl.Engine;
import com.twitter.finagle.ssl.Engine$;
import com.twitter.finagle.ssl.KeyCredentials;
import com.twitter.finagle.ssl.SslConfigurationException$;
import com.twitter.finagle.ssl.server.SslServerConfiguration;
import com.twitter.finagle.ssl.server.SslServerEngineFactory$;
import com.twitter.util.Try;
import com.twitter.util.security.PrivateKeyFile;
import com.twitter.util.security.X509CertificateFile;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import scala.Function1;
import scala.MatchError;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;

public final class Netty4ServerSslConfigurations$ {
    public static Netty4ServerSslConfigurations$ MODULE$;

    static {
        new Netty4ServerSslConfigurations$();
    }

    private SslContextBuilder configureServerApplicationProtocols(SslContextBuilder builder, ApplicationProtocols applicationProtocols) {
        return Netty4SslConfigurations$.MODULE$.configureApplicationProtocols(builder, applicationProtocols, ApplicationProtocolConfig.Protocol.NPN_AND_ALPN);
    }

    private SslContextBuilder startServerWithKey(KeyCredentials keyCredentials) {
        Try try_;
        KeyCredentials keyCredentials2 = keyCredentials;
        if (KeyCredentials.Unspecified$.MODULE$.equals(keyCredentials2)) {
            throw SslConfigurationException$.MODULE$.notSupported("KeyCredentials.Unspecified", "Netty4ServerEngineFactory");
        }
        if (keyCredentials2 instanceof KeyCredentials.CertAndKey) {
            KeyCredentials.CertAndKey certAndKey = (KeyCredentials.CertAndKey)keyCredentials2;
            File certFile = certAndKey.certificateFile();
            File keyFile = certAndKey.keyFile();
            try_ = new PrivateKeyFile(keyFile).readPrivateKey().flatMap((Function1 & Serializable & scala.Serializable)key -> new X509CertificateFile(certFile).readX509Certificate().map((Function1 & Serializable & scala.Serializable)cert -> SslContextBuilder.forServer((PrivateKey)key, (X509Certificate[])new X509Certificate[]{cert})));
        } else if (keyCredentials2 instanceof KeyCredentials.CertKeyAndChain) {
            KeyCredentials.CertKeyAndChain certKeyAndChain = (KeyCredentials.CertKeyAndChain)keyCredentials2;
            File certFile = certKeyAndChain.certificateFile();
            File keyFile = certKeyAndChain.keyFile();
            File chainFile = certKeyAndChain.caCertificateFile();
            try_ = new PrivateKeyFile(keyFile).readPrivateKey().flatMap((Function1 & Serializable & scala.Serializable)key -> new X509CertificateFile(certFile).readX509Certificate().flatMap((Function1 & Serializable & scala.Serializable)cert -> new X509CertificateFile(chainFile).readX509Certificates().map((Function1 & Serializable & scala.Serializable)chain -> {
                X509Certificate x509Certificate = cert;
                return SslContextBuilder.forServer((PrivateKey)key, (X509Certificate[])((X509Certificate[])((TraversableOnce)chain.$plus$colon((Object)x509Certificate, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(X509Certificate.class))));
            })));
        } else {
            throw new MatchError((Object)keyCredentials2);
        }
        Try builder = try_;
        return Netty4SslConfigurations$.MODULE$.unwrapTryContextBuilder((Try<SslContextBuilder>)builder);
    }

    public SslContext createServerContext(SslServerConfiguration config, boolean forceJdk) {
        SslContextBuilder builder = this.startServerWithKey(config.keyCredentials());
        SslContextBuilder withProvider = Netty4SslConfigurations$.MODULE$.configureProvider(builder, forceJdk);
        SslContextBuilder withTrust = Netty4SslConfigurations$.MODULE$.configureTrust(withProvider, config.trustCredentials());
        SslContextBuilder withAppProtocols = this.configureServerApplicationProtocols(withTrust, config.applicationProtocols());
        return withAppProtocols.build();
    }

    public Engine createServerEngine(SslServerConfiguration config, SslContext context, ByteBufAllocator allocator) {
        Engine engine = new Engine(context.newEngine(allocator), Engine$.MODULE$.$lessinit$greater$default$2(), Engine$.MODULE$.$lessinit$greater$default$3());
        SslServerEngineFactory$.MODULE$.configureEngine(engine, config);
        return engine;
    }

    private Netty4ServerSslConfigurations$() {
        MODULE$ = this;
    }
}

