/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.processor;

import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.DataProcessingException;
import com.univocity.parsers.common.ParsingContext;
import com.univocity.parsers.common.processor.CustomMatcher;
import com.univocity.parsers.common.processor.RowProcessor;
import com.univocity.parsers.common.processor.RowProcessorSwitch;
import java.util.Arrays;
import java.util.Comparator;

public class InputValueSwitch
extends RowProcessorSwitch {
    private int columnIndex = -1;
    private String columnName = null;
    private Switch[] switches = new Switch[0];
    private Switch defaultSwitch = null;
    private String[] headers;
    private int[] indexes;
    private static final Comparator<String> caseSensitiveComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1 == o2 || o1 != null && o1.equals(o2) ? 0 : 1;
        }
    };
    private static final Comparator<String> caseInsensitiveComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1 == o2 || o1 != null && o1.equalsIgnoreCase(o2) ? 0 : 1;
        }
    };
    private Comparator<String> comparator = caseInsensitiveComparator;

    public InputValueSwitch() {
        this(0);
    }

    public InputValueSwitch(int columnIndex) {
        if (columnIndex < 0) {
            throw new IllegalArgumentException("Column index must be positive");
        }
        this.columnIndex = columnIndex;
    }

    public InputValueSwitch(String columnName) {
        if (columnName == null || columnName.trim().isEmpty()) {
            throw new IllegalArgumentException("Column name cannot be blank");
        }
        this.columnName = columnName;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.comparator = caseSensitive ? caseSensitiveComparator : caseInsensitiveComparator;
    }

    public void setComparator(Comparator<String> comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException("Comparator must not be null");
        }
        this.comparator = comparator;
    }

    public void setDefaultSwitch(RowProcessor rowProcessor, String ... headersToUse) {
        this.defaultSwitch = new Switch(rowProcessor, headersToUse, null, null, null);
    }

    public void setDefaultSwitch(RowProcessor rowProcessor) {
        this.defaultSwitch = new Switch(rowProcessor, null, null, null, null);
    }

    public void setDefaultSwitch(RowProcessor rowProcessor, int ... indexesToUse) {
        this.defaultSwitch = new Switch(rowProcessor, null, indexesToUse, null, null);
    }

    public void addSwitchForValue(String value, RowProcessor rowProcessor) {
        this.switches = Arrays.copyOf(this.switches, this.switches.length + 1);
        this.switches[this.switches.length - 1] = new Switch(rowProcessor, null, null, value, null);
    }

    public void addSwitchForValue(String value, RowProcessor rowProcessor, String ... headersToUse) {
        this.switches = Arrays.copyOf(this.switches, this.switches.length + 1);
        this.switches[this.switches.length - 1] = new Switch(rowProcessor, headersToUse, null, value, null);
    }

    public void addSwitchForValue(CustomMatcher matcher, RowProcessor rowProcessor) {
        this.switches = Arrays.copyOf(this.switches, this.switches.length + 1);
        this.switches[this.switches.length - 1] = new Switch(rowProcessor, null, null, null, matcher);
    }

    public void addSwitchForValue(CustomMatcher matcher, RowProcessor rowProcessor, String ... headersToUse) {
        this.switches = Arrays.copyOf(this.switches, this.switches.length + 1);
        this.switches[this.switches.length - 1] = new Switch(rowProcessor, headersToUse, null, null, matcher);
    }

    public void addSwitchForValue(String value, RowProcessor rowProcessor, int ... indexesToUse) {
        this.switches = Arrays.copyOf(this.switches, this.switches.length + 1);
        this.switches[this.switches.length - 1] = new Switch(rowProcessor, null, indexesToUse, value, null);
    }

    public void addSwitchForValue(CustomMatcher matcher, RowProcessor rowProcessor, int ... indexesToUse) {
        this.switches = Arrays.copyOf(this.switches, this.switches.length + 1);
        this.switches[this.switches.length - 1] = new Switch(rowProcessor, null, indexesToUse, null, matcher);
    }

    @Override
    public String[] getHeaders() {
        return this.headers;
    }

    @Override
    public int[] getIndexes() {
        return this.indexes;
    }

    @Override
    protected RowProcessor switchRowProcessor(String[] row, ParsingContext context) {
        if (this.columnIndex == -1) {
            Object[] headers = context.headers();
            if (headers == null) {
                throw new DataProcessingException("Unable to determine position of column named '" + this.columnName + "' as no headers have been defined nor extracted from the input");
            }
            this.columnIndex = ArgumentUtils.indexOf(headers, this.columnName);
            if (this.columnIndex == -1) {
                throw new DataProcessingException("Unable to determine position of column named '" + this.columnName + "' as it does not exist in the headers. Available headers are " + Arrays.toString(headers));
            }
        }
        if (this.columnIndex < row.length) {
            String valueToMatch = row[this.columnIndex];
            for (int i = 0; i < this.switches.length; ++i) {
                Switch s = this.switches[i];
                if (s.matcher != null && s.matcher.matches(valueToMatch)) {
                    return s.processor;
                }
                if (this.comparator.compare(valueToMatch, s.value) != 0) continue;
                this.headers = s.headers;
                this.indexes = s.indexes;
                return s.processor;
            }
        }
        if (this.defaultSwitch != null) {
            this.headers = this.defaultSwitch.headers;
            this.indexes = this.defaultSwitch.indexes;
            return this.defaultSwitch.processor;
        }
        this.headers = null;
        this.indexes = null;
        throw new DataProcessingException("Unable to process input row. No switches activated and no default switch defined.", this.columnIndex, row, null);
    }

    private static class Switch {
        final RowProcessor processor;
        final String[] headers;
        final int[] indexes;
        final String value;
        final CustomMatcher matcher;

        Switch(RowProcessor processor, String[] headers, int[] indexes, String value, CustomMatcher matcher) {
            this.processor = processor;
            this.headers = headers == null || headers.length == 0 ? null : headers;
            this.indexes = indexes == null || indexes.length == 0 ? null : indexes;
            this.value = value == null ? null : value.intern();
            this.matcher = matcher;
        }
    }
}

