/*
 * Decompiled with CFR 0.152.
 */
package com.vip.vjtools.vjkit.collection;

import com.google.common.base.Preconditions;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.vip.vjtools.vjkit.base.annotation.NotNull;
import com.vip.vjtools.vjkit.base.annotation.Nullable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.lang3.Validate;

public class MapUtil {
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    public static <K, V> V putIfAbsentReturnLast(@NotNull ConcurrentMap<K, V> map, K key, V value) {
        V result = map.putIfAbsent(key, value);
        return result != null ? result : value;
    }

    public static <K, V> V createIfAbsentReturnLast(@NotNull ConcurrentMap<K, V> map, K key, @NotNull ValueCreator<? extends V> creator) {
        Object value = map.get(key);
        if (value == null) {
            return MapUtil.putIfAbsentReturnLast(map, key, creator.get());
        }
        return value;
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMapWithCapacity(int expectedSize, float loadFactor) {
        int finalSize = (int)((double)expectedSize / (double)loadFactor + 1.0);
        return new HashMap(finalSize, loadFactor);
    }

    public static <K, V> HashMap<K, V> newHashMap(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key, value);
        return map;
    }

    public static <K, V> HashMap<K, V> newHashMap(@NotNull K[] keys, @NotNull V[] values) {
        Validate.isTrue((keys.length == values.length ? 1 : 0) != 0, (String)"keys.length is %d but values.length is %d", (Object[])new Object[]{keys.length, values.length});
        HashMap<K, V> map = new HashMap<K, V>(keys.length * 2);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static <K, V> HashMap<K, V> newHashMap(@NotNull List<K> keys, @NotNull List<V> values) {
        Validate.isTrue((keys.size() == values.size() ? 1 : 0) != 0, (String)"keys.length is %s  but values.length is %s", (Object[])new Object[]{keys.size(), values.size()});
        HashMap<K, V> map = new HashMap<K, V>(keys.size() * 2);
        Iterator<K> keyIt = keys.iterator();
        Iterator<V> valueIt = values.iterator();
        while (keyIt.hasNext()) {
            map.put(keyIt.next(), valueIt.next());
        }
        return map;
    }

    public static <K extends Comparable, V> TreeMap<K, V> newSortedMap() {
        return new TreeMap();
    }

    public static <C, K extends C, V> TreeMap<K, V> newSortedMap(@Nullable Comparator<C> comparator) {
        return Maps.newTreeMap(comparator);
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> newEnumMap(@NotNull Class<K> type) {
        return new EnumMap((Class)Preconditions.checkNotNull(type));
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> ConcurrentSkipListMap<K, V> newConcurrentSortedMap() {
        return new ConcurrentSkipListMap();
    }

    public static final <K, V> Map<K, V> emptyMap() {
        return Collections.emptyMap();
    }

    public static <K, V> Map<K, V> emptyMapIfNull(Map<K, V> map) {
        return map == null ? Collections.EMPTY_MAP : map;
    }

    public static <K, V> Map<K, V> singletonMap(K key, V value) {
        return Collections.singletonMap(key, value);
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<? extends K, ? extends V> m) {
        return Collections.unmodifiableMap(m);
    }

    public static <K, V> SortedMap<K, V> unmodifiableSortedMap(SortedMap<K, ? extends V> m) {
        return Collections.unmodifiableSortedMap(m);
    }

    public static <K, V> MapDifference<K, V> difference(Map<? extends K, ? extends V> left, Map<? extends K, ? extends V> right) {
        return Maps.difference(left, right);
    }

    public static <K, V extends Comparable> Map<K, V> sortByValue(Map<K, V> map, boolean reverse) {
        return MapUtil.sortByValueInternal(map, reverse ? Ordering.from(new ComparableEntryValueComparator()).reverse() : new ComparableEntryValueComparator());
    }

    public static <K, V> Map<K, V> sortByValue(Map<K, V> map, Comparator<? super V> comparator) {
        return MapUtil.sortByValueInternal(map, new EntryValueComparator(comparator));
    }

    private static <K, V> Map<K, V> sortByValueInternal(Map<K, V> map, Comparator<Map.Entry<K, V>> comparator) {
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        Map.Entry[] entryArray = entrySet.toArray(new Map.Entry[0]);
        Arrays.sort(entryArray, comparator);
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : entryArray) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K, V extends Comparable> Map<K, V> topNByValue(Map<K, V> map, boolean reverse, int n) {
        return MapUtil.topNByValueInternal(map, n, reverse ? Ordering.from(new ComparableEntryValueComparator()).reverse() : new ComparableEntryValueComparator());
    }

    public static <K, V> Map<K, V> topNByValue(Map<K, V> map, Comparator<? super V> comparator, int n) {
        return MapUtil.topNByValueInternal(map, n, new EntryValueComparator(comparator));
    }

    private static <K, V> Map<K, V> topNByValueInternal(Map<K, V> map, int n, Comparator<Map.Entry<K, V>> comparator) {
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        Map.Entry[] entryArray = entrySet.toArray(new Map.Entry[0]);
        Arrays.sort(entryArray, comparator);
        LinkedHashMap result = new LinkedHashMap();
        int size = Math.min(n, entryArray.length);
        for (int i = 0; i < size; ++i) {
            Map.Entry entry = entryArray[i];
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static final class EntryValueComparator<K, V>
    implements Comparator<Map.Entry<K, V>> {
        private final Comparator<? super V> comparator;

        private EntryValueComparator(Comparator<? super V> comparator2) {
            this.comparator = comparator2;
        }

        @Override
        public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
            return this.comparator.compare(o1.getValue(), o2.getValue());
        }
    }

    private static final class ComparableEntryValueComparator<K, V extends Comparable>
    implements Comparator<Map.Entry<K, V>> {
        private ComparableEntryValueComparator() {
        }

        @Override
        public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
            return ((Comparable)o1.getValue()).compareTo(o2.getValue());
        }
    }

    public static interface ValueCreator<T> {
        public T get();
    }
}

