/*
 * Decompiled with CFR 0.152.
 */
package com.vip.vjtools.vjkit.concurrent;

import com.vip.vjtools.vjkit.number.RandomUtil;
import org.apache.commons.lang3.Validate;

public class Sampler {
    private static final Double ALWAYS = 100.0;
    private static final Double NEVER = 0.0;
    private double threshold;

    protected Sampler() {
    }

    protected Sampler(double selectPercent) {
        Validate.isTrue((selectPercent >= 0.0 && selectPercent <= 100.0 ? 1 : 0) != 0, (String)("Invalid selectPercent value: " + selectPercent), (Object[])new Object[0]);
        this.threshold = selectPercent / 100.0;
    }

    public static Sampler create(Double selectPercent) {
        if (selectPercent.equals(ALWAYS)) {
            return new AlwaysSampler();
        }
        if (selectPercent.equals(NEVER)) {
            return new NeverSampler();
        }
        return new Sampler(selectPercent);
    }

    public boolean select() {
        return RandomUtil.threadLocalRandom().nextDouble() < this.threshold;
    }

    protected static class NeverSampler
    extends Sampler {
        protected NeverSampler() {
        }

        @Override
        public boolean select() {
            return false;
        }
    }

    protected static class AlwaysSampler
    extends Sampler {
        protected AlwaysSampler() {
        }

        @Override
        public boolean select() {
            return true;
        }
    }
}

