/*
 * Decompiled with CFR 0.152.
 */
package com.vip.vjtools.vjkit.concurrent.threadpool;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.vip.vjtools.vjkit.base.annotation.NotNull;
import com.vip.vjtools.vjkit.base.annotation.Nullable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolUtil {
    public static boolean gracefulShutdown(@Nullable ExecutorService threadPool, int shutdownTimeoutMills) {
        return threadPool == null || MoreExecutors.shutdownAndAwaitTermination((ExecutorService)threadPool, (long)shutdownTimeoutMills, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public static boolean gracefulShutdown(@Nullable ExecutorService threadPool, int shutdownTimeout, TimeUnit timeUnit) {
        return threadPool == null || MoreExecutors.shutdownAndAwaitTermination((ExecutorService)threadPool, (long)shutdownTimeout, (TimeUnit)timeUnit);
    }

    public static ThreadFactory buildThreadFactory(@NotNull String threadNamePrefix) {
        return new ThreadFactoryBuilder().setNameFormat(threadNamePrefix + "-%d").build();
    }

    public static ThreadFactory buildThreadFactory(@NotNull String threadNamePrefix, @NotNull boolean daemon) {
        return new ThreadFactoryBuilder().setNameFormat(threadNamePrefix + "-%d").setDaemon(daemon).build();
    }

    public static Runnable safeRunnable(@NotNull Runnable runnable) {
        return new SafeRunnable(runnable);
    }

    private static class SafeRunnable
    implements Runnable {
        private static Logger logger = LoggerFactory.getLogger(SafeRunnable.class);
        private Runnable runnable;

        public SafeRunnable(Runnable runnable) {
            Validate.notNull((Object)runnable);
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Throwable e) {
                logger.error("Unexpected error occurred in task", e);
            }
        }
    }
}

