/*
 * Decompiled with CFR 0.152.
 */
package com.vip.vjtools.vjkit.io;

import com.google.common.io.Files;
import com.vip.vjtools.vjkit.base.Platforms;
import com.vip.vjtools.vjkit.text.MoreStringUtil;
import org.apache.commons.lang3.StringUtils;

public class FilePathUtil {
    public static String normalizePath(String path) {
        if (Platforms.FILE_PATH_SEPARATOR_CHAR == '\\' && StringUtils.indexOf((CharSequence)path, (int)47) != -1) {
            return StringUtils.replaceChars((String)path, (char)'/', (char)'\\');
        }
        return path;
    }

    public static String simplifyPath(String path) {
        return Files.simplifyPath((String)path);
    }

    public static String concat(String baseName, String ... appendName) {
        if (appendName.length == 0) {
            return baseName;
        }
        StringBuilder concatName = new StringBuilder();
        if (MoreStringUtil.endWith(baseName, Platforms.FILE_PATH_SEPARATOR_CHAR)) {
            concatName.append(baseName).append(appendName[0]);
        } else {
            concatName.append(baseName).append(Platforms.FILE_PATH_SEPARATOR_CHAR).append(appendName[0]);
        }
        if (appendName.length > 1) {
            for (int i = 1; i < appendName.length; ++i) {
                concatName.append(Platforms.FILE_PATH_SEPARATOR_CHAR).append(appendName[i]);
            }
        }
        return concatName.toString();
    }

    public static String getParentPath(String path) {
        String parentPath = path;
        if (Platforms.FILE_PATH_SEPARATOR.equals(parentPath)) {
            return parentPath;
        }
        int idx = (parentPath = MoreStringUtil.removeEnd(parentPath, Platforms.FILE_PATH_SEPARATOR_CHAR)).lastIndexOf(Platforms.FILE_PATH_SEPARATOR_CHAR);
        parentPath = idx >= 0 ? parentPath.substring(0, idx + 1) : Platforms.FILE_PATH_SEPARATOR;
        return parentPath;
    }

    public static String getJarPath(Class<?> clazz) {
        return clazz.getProtectionDomain().getCodeSource().getLocation().getFile();
    }
}

