/*
 * Decompiled with CFR 0.152.
 */
package com.vip.vjtools.vjkit.io;

import com.vip.vjtools.vjkit.base.Platforms;
import com.vip.vjtools.vjkit.base.annotation.NotNull;
import com.vip.vjtools.vjkit.base.annotation.Nullable;
import com.vip.vjtools.vjkit.text.Charsets;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class FileUtil {
    private static FileVisitor<Path> deleteFileVisitor = new SimpleFileVisitor<Path>(){

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            Files.delete(dir);
            return FileVisitResult.CONTINUE;
        }
    };

    public static byte[] toByteArray(File file) throws IOException {
        return Files.readAllBytes(file.toPath());
    }

    public static String toString(File file) throws IOException {
        return com.google.common.io.Files.toString((File)file, (Charset)Charsets.UTF_8);
    }

    public static List<String> toLines(File file) throws IOException {
        return Files.readAllLines(file.toPath(), Charsets.UTF_8);
    }

    public static void write(CharSequence data, File file) throws IOException {
        Validate.notNull((Object)file);
        Validate.notNull((Object)data);
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), Charsets.UTF_8, new OpenOption[0]);){
            writer.append(data);
        }
    }

    public static void append(CharSequence data, File file) throws IOException {
        Validate.notNull((Object)file);
        Validate.notNull((Object)data);
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), Charsets.UTF_8, StandardOpenOption.APPEND);){
            writer.append(data);
        }
    }

    public static InputStream asInputStream(String fileName) throws IOException {
        return FileUtil.asInputStream(FileUtil.getPath(fileName));
    }

    public static InputStream asInputStream(File file) throws IOException {
        Validate.notNull((Object)file, (String)"file is null", (Object[])new Object[0]);
        return FileUtil.asInputStream(file.toPath());
    }

    public static InputStream asInputStream(Path path) throws IOException {
        Validate.notNull((Object)path, (String)"path is null", (Object[])new Object[0]);
        return Files.newInputStream(path, new OpenOption[0]);
    }

    public static OutputStream asOututStream(String fileName) throws IOException {
        return FileUtil.asOututStream(FileUtil.getPath(fileName));
    }

    public static OutputStream asOututStream(File file) throws IOException {
        Validate.notNull((Object)file, (String)"file is null", (Object[])new Object[0]);
        return FileUtil.asOututStream(file.toPath());
    }

    public static OutputStream asOututStream(Path path) throws IOException {
        Validate.notNull((Object)path, (String)"path is null", (Object[])new Object[0]);
        return Files.newOutputStream(path, new OpenOption[0]);
    }

    public static BufferedReader asBufferedReader(String fileName) throws IOException {
        Validate.notBlank((CharSequence)fileName, (String)"filename is blank", (Object[])new Object[0]);
        return FileUtil.asBufferedReader(FileUtil.getPath(fileName));
    }

    public static BufferedReader asBufferedReader(Path path) throws IOException {
        Validate.notNull((Object)path, (String)"path is null", (Object[])new Object[0]);
        return Files.newBufferedReader(path, Charsets.UTF_8);
    }

    public static BufferedWriter asBufferedWriter(String fileName) throws IOException {
        Validate.notBlank((CharSequence)fileName, (String)"filename is blank", (Object[])new Object[0]);
        return Files.newBufferedWriter(FileUtil.getPath(fileName), Charsets.UTF_8, new OpenOption[0]);
    }

    public static BufferedWriter asBufferedWriter(Path path) throws IOException {
        Validate.notNull((Object)path, (String)"path is null", (Object[])new Object[0]);
        return Files.newBufferedWriter(path, Charsets.UTF_8, new OpenOption[0]);
    }

    public static void copy(@NotNull File from, @NotNull File to) throws IOException {
        Validate.notNull((Object)from);
        Validate.notNull((Object)to);
        FileUtil.copy(from.toPath(), to.toPath());
    }

    public static void copy(@NotNull Path from, @NotNull Path to) throws IOException {
        Validate.notNull((Object)from);
        Validate.notNull((Object)to);
        if (Files.isDirectory(from, new LinkOption[0])) {
            FileUtil.copyDir(from, to);
        } else {
            FileUtil.copyFile(from, to);
        }
    }

    public static void copyFile(@NotNull File from, @NotNull File to) throws IOException {
        Validate.notNull((Object)from);
        Validate.notNull((Object)to);
        FileUtil.copyFile(from.toPath(), to.toPath());
    }

    public static void copyFile(@NotNull Path from, @NotNull Path to) throws IOException {
        Validate.isTrue((boolean)Files.exists(from, new LinkOption[0]), (String)"%s is not exist or not a file", (Object[])new Object[]{from});
        Validate.notNull((Object)to);
        Validate.isTrue((!FileUtil.isDirExists(to) ? 1 : 0) != 0, (String)"%s is exist but it is a dir", (Object[])new Object[]{to});
        Files.copy(from, to, new CopyOption[0]);
    }

    public static void copyDir(@NotNull File from, @NotNull File to) throws IOException {
        Validate.isTrue((boolean)FileUtil.isDirExists(from), (String)"%s is not exist or not a dir", (Object[])new Object[]{from});
        Validate.notNull((Object)to);
        FileUtil.copyDir(from.toPath(), to.toPath());
    }

    public static void copyDir(@NotNull Path from, @NotNull Path to) throws IOException {
        Validate.isTrue((boolean)FileUtil.isDirExists(from), (String)"%s is not exist or not a dir", (Object[])new Object[]{from});
        Validate.notNull((Object)to);
        FileUtil.makesureDirExists(to);
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(from);){
            for (Path path : dirStream) {
                FileUtil.copy(path, to.resolve(path.getFileName()));
            }
        }
    }

    public static void moveFile(@NotNull File from, @NotNull File to) throws IOException {
        Validate.notNull((Object)from);
        Validate.notNull((Object)to);
        FileUtil.moveFile(from.toPath(), to.toPath());
    }

    public static void moveFile(@NotNull Path from, @NotNull Path to) throws IOException {
        Validate.isTrue((boolean)FileUtil.isFileExists(from), (String)"%s is not exist or not a file", (Object[])new Object[]{from});
        Validate.notNull((Object)to);
        Validate.isTrue((!FileUtil.isDirExists(to) ? 1 : 0) != 0, (String)"%s is  exist but it is a dir", (Object[])new Object[]{to});
        Files.move(from, to, new CopyOption[0]);
    }

    public static void moveDir(@NotNull File from, @NotNull File to) throws IOException {
        Validate.isTrue((boolean)FileUtil.isDirExists(from), (String)"%s is not exist or not a dir", (Object[])new Object[]{from});
        Validate.notNull((Object)to);
        Validate.isTrue((!FileUtil.isFileExists(to) ? 1 : 0) != 0, (String)"%s is exist but it is a file", (Object[])new Object[]{to});
        boolean rename = from.renameTo(to);
        if (!rename) {
            if (to.getCanonicalPath().startsWith(from.getCanonicalPath() + File.separator)) {
                throw new IOException("Cannot move directory: " + from + " to a subdirectory of itself: " + to);
            }
            FileUtil.copyDir(from, to);
            FileUtil.deleteDir(from);
            if (from.exists()) {
                throw new IOException("Failed to delete original directory '" + from + "' after copy to '" + to + '\'');
            }
        }
    }

    public static void touch(String filePath) throws IOException {
        FileUtil.touch(new File(filePath));
    }

    public static void touch(File file) throws IOException {
        com.google.common.io.Files.touch((File)file);
    }

    public static void deleteFile(@Nullable File file) throws IOException {
        Validate.isTrue((boolean)FileUtil.isFileExists(file), (String)"%s is not exist or not a file", (Object[])new Object[]{file});
        FileUtil.deleteFile(file.toPath());
    }

    public static void deleteFile(@Nullable Path path) throws IOException {
        Validate.isTrue((boolean)FileUtil.isFileExists(path), (String)"%s is not exist or not a file", (Object[])new Object[]{path});
        Files.delete(path);
    }

    public static void deleteDir(Path dir) throws IOException {
        Validate.isTrue((boolean)FileUtil.isDirExists(dir), (String)"%s is not exist or not a dir", (Object[])new Object[]{dir});
        Files.walkFileTree(dir, deleteFileVisitor);
    }

    public static void deleteDir(File dir) throws IOException {
        Validate.isTrue((boolean)FileUtil.isDirExists(dir), (String)"%s is not exist or not a dir", (Object[])new Object[]{dir});
        FileUtil.deleteDir(dir.toPath());
    }

    public static boolean isDirExists(String dirPath) {
        if (dirPath == null) {
            return false;
        }
        return FileUtil.isDirExists(FileUtil.getPath(dirPath));
    }

    public static boolean isDirExists(Path dirPath) {
        return dirPath != null && Files.exists(dirPath, new LinkOption[0]) && Files.isDirectory(dirPath, new LinkOption[0]);
    }

    public static boolean isDirExists(File dir) {
        if (dir == null) {
            return false;
        }
        return FileUtil.isDirExists(dir.toPath());
    }

    public static void makesureDirExists(String dirPath) throws IOException {
        FileUtil.makesureDirExists(FileUtil.getPath(dirPath));
    }

    public static void makesureDirExists(File file) throws IOException {
        Validate.notNull((Object)file);
        FileUtil.makesureDirExists(file.toPath());
    }

    public static void makesureDirExists(Path dirPath) throws IOException {
        Validate.notNull((Object)dirPath);
        Files.createDirectories(dirPath, new FileAttribute[0]);
    }

    public static void makesureParentDirExists(File file) throws IOException {
        Validate.notNull((Object)file);
        FileUtil.makesureDirExists(file.getParentFile());
    }

    public static boolean isFileExists(String fileName) {
        if (fileName == null) {
            return false;
        }
        return FileUtil.isFileExists(FileUtil.getPath(fileName));
    }

    public static boolean isFileExists(File file) {
        if (file == null) {
            return false;
        }
        return FileUtil.isFileExists(file.toPath());
    }

    public static boolean isFileExists(Path path) {
        if (path == null) {
            return false;
        }
        return Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0]);
    }

    public static Path createTempDir() throws IOException {
        return Files.createTempDirectory(System.currentTimeMillis() + "-", new FileAttribute[0]);
    }

    public static Path createTempFile() throws IOException {
        return Files.createTempFile("tmp-", ".tmp", new FileAttribute[0]);
    }

    public static Path createTempFile(String prefix, String suffix) throws IOException {
        return Files.createTempFile(prefix, suffix, new FileAttribute[0]);
    }

    private static Path getPath(String filePath) {
        return Paths.get(filePath, new String[0]);
    }

    public static String getFileName(@NotNull String fullName) {
        Validate.notEmpty((CharSequence)fullName);
        int last = fullName.lastIndexOf(Platforms.FILE_PATH_SEPARATOR_CHAR);
        return fullName.substring(last + 1);
    }

    public static String getFileExtension(File file) {
        return com.google.common.io.Files.getFileExtension((String)file.getName());
    }

    public static String getFileExtension(String fullName) {
        return com.google.common.io.Files.getFileExtension((String)fullName);
    }
}

