/*
 * Decompiled with CFR 0.152.
 */
package com.vip.vjtools.vjkit.net;

import com.google.common.annotations.Beta;
import com.vip.vjtools.vjkit.base.Platforms;
import com.vip.vjtools.vjkit.base.SystemPropertiesUtil;
import com.vip.vjtools.vjkit.collection.MapUtil;
import com.vip.vjtools.vjkit.net.IPUtil;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Random;
import javax.net.ServerSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class NetUtil {
    private static Logger logger = LoggerFactory.getLogger(NetUtil.class);
    public static final int PORT_RANGE_MIN = 1024;
    public static final int PORT_RANGE_MAX = 65535;
    private static Random random = new Random();

    public static InetAddress getLocalAddress() {
        return LocalAddressHoler.INSTANCE.localInetAddress;
    }

    public static String getLocalHost() {
        return LocalAddressHoler.INSTANCE.localHost;
    }

    public static String getHostName() {
        return LocalAddressHoler.INSTANCE.hostName;
    }

    public static boolean isPortAvailable(int port) {
        try {
            ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));
            serverSocket.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static int findRandomAvailablePort() {
        return NetUtil.findRandomAvailablePort(1024, 65535);
    }

    public static int findRandomAvailablePort(int minPort, int maxPort) {
        int candidatePort;
        int portRange = maxPort - minPort;
        int searchCounter = 0;
        do {
            if (++searchCounter <= portRange) continue;
            throw new IllegalStateException(String.format("Could not find an available tcp port in the range [%d, %d] after %d attempts", minPort, maxPort, searchCounter));
        } while (!NetUtil.isPortAvailable(candidatePort = minPort + random.nextInt(portRange + 1)));
        return candidatePort;
    }

    public static int findAvailablePortFrom(int minPort) {
        for (int port = minPort; port < 65535; ++port) {
            if (!NetUtil.isPortAvailable(port)) continue;
            return port;
        }
        throw new IllegalStateException(String.format("Could not find an available tcp port in the range [%d, %d]", minPort, 65535));
    }

    private static class LocalAddress {
        private InetAddress localInetAddress;
        private String localHost;
        private String hostName;

        public LocalAddress() {
            this.initLocalAddress();
            this.hostName = Platforms.IS_WINDOWS ? System.getenv("COMPUTERNAME") : System.getenv("HOSTNAME");
        }

        private void initLocalAddress() {
            NetworkInterface nic = null;
            try {
                this.localInetAddress = InetAddress.getLocalHost();
                nic = NetworkInterface.getByInetAddress(this.localInetAddress);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (this.localInetAddress == null || nic == null || this.localInetAddress.isLoopbackAddress() || this.localInetAddress instanceof Inet6Address) {
                InetAddress lookedUpAddr = LocalAddress.findLocalAddressViaNetworkInterface();
                try {
                    this.localInetAddress = lookedUpAddr != null ? lookedUpAddr : InetAddress.getByName("127.0.0.1");
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            this.localHost = IPUtil.toIpString(this.localInetAddress);
            logger.info("localhost is {}", (Object)this.localHost);
        }

        private static InetAddress findLocalAddressViaNetworkInterface() {
            String preferNamePrefix = SystemPropertiesUtil.getString("localhost.prefer.nic.prefix", "LOCALHOST_PREFER_NIC_PREFIX", "bond0.");
            String defaultNicList = SystemPropertiesUtil.getString("localhost.default.nic.list", "LOCALHOST_DEFAULT_NIC_LIST", "bond0,eth0,em0,br0");
            InetAddress resultAddress = null;
            HashMap<String, NetworkInterface> candidateInterfaces = MapUtil.newHashMap();
            try {
                Enumeration<NetworkInterface> allInterfaces = NetworkInterface.getNetworkInterfaces();
                while (allInterfaces.hasMoreElements()) {
                    NetworkInterface nic = allInterfaces.nextElement();
                    try {
                        if (!nic.isUp()) continue;
                        if (!nic.supportsMulticast()) {
                        }
                    }
                    catch (SocketException ignored) {}
                    continue;
                    String name = nic.getName();
                    if (name.startsWith(preferNamePrefix)) {
                        resultAddress = LocalAddress.findAvailableInetAddress(nic);
                        if (resultAddress == null) continue;
                        return resultAddress;
                    }
                    candidateInterfaces.put(name, nic);
                }
                for (String nifName : defaultNicList.split(",")) {
                    NetworkInterface nic = (NetworkInterface)candidateInterfaces.get(nifName);
                    if (nic == null || (resultAddress = LocalAddress.findAvailableInetAddress(nic)) == null) continue;
                    return resultAddress;
                }
            }
            catch (SocketException e) {
                return null;
            }
            return null;
        }

        private static InetAddress findAvailableInetAddress(NetworkInterface nic) {
            Enumeration<InetAddress> indetAddresses = nic.getInetAddresses();
            while (indetAddresses.hasMoreElements()) {
                InetAddress inetAddress = indetAddresses.nextElement();
                if (inetAddress instanceof Inet6Address || inetAddress.isLoopbackAddress()) continue;
                return inetAddress;
            }
            return null;
        }
    }

    private static class LocalAddressHoler {
        static final LocalAddress INSTANCE = new LocalAddress();

        private LocalAddressHoler() {
        }
    }
}

