/*
 * Decompiled with CFR 0.152.
 */
package com.vip.vjtools.vjkit.time;

import com.vip.vjtools.vjkit.base.annotation.NotNull;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;

public class DateUtil {
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    private static final int[] MONTH_LENGTH = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public static boolean isSameDay(@NotNull Date date1, @NotNull Date date2) {
        return DateUtils.isSameDay((Date)date1, (Date)date2);
    }

    public static boolean isSameTime(@NotNull Date date1, @NotNull Date date2) {
        return date1.compareTo(date2) == 0;
    }

    public static boolean isBetween(@NotNull Date date, @NotNull Date start, @NotNull Date end) {
        if (date == null || start == null || end == null || start.after(end)) {
            throw new IllegalArgumentException("some date parameters is null or dateBein after dateEnd");
        }
        return !date.before(start) && !date.after(end);
    }

    public static Date addMonths(@NotNull Date date, int amount) {
        return DateUtils.addMonths((Date)date, (int)amount);
    }

    public static Date subMonths(@NotNull Date date, int amount) {
        return DateUtils.addMonths((Date)date, (int)(-amount));
    }

    public static Date addWeeks(@NotNull Date date, int amount) {
        return DateUtils.addWeeks((Date)date, (int)amount);
    }

    public static Date subWeeks(@NotNull Date date, int amount) {
        return DateUtils.addWeeks((Date)date, (int)(-amount));
    }

    public static Date addDays(@NotNull Date date, int amount) {
        return DateUtils.addDays((Date)date, (int)amount);
    }

    public static Date subDays(@NotNull Date date, int amount) {
        return DateUtils.addDays((Date)date, (int)(-amount));
    }

    public static Date addHours(@NotNull Date date, int amount) {
        return DateUtils.addHours((Date)date, (int)amount);
    }

    public static Date subHours(@NotNull Date date, int amount) {
        return DateUtils.addHours((Date)date, (int)(-amount));
    }

    public static Date addMinutes(@NotNull Date date, int amount) {
        return DateUtils.addMinutes((Date)date, (int)amount);
    }

    public static Date subMinutes(@NotNull Date date, int amount) {
        return DateUtils.addMinutes((Date)date, (int)(-amount));
    }

    public static Date addSeconds(@NotNull Date date, int amount) {
        return DateUtils.addSeconds((Date)date, (int)amount);
    }

    public static Date subSeconds(@NotNull Date date, int amount) {
        return DateUtils.addSeconds((Date)date, (int)(-amount));
    }

    public static Date setYears(@NotNull Date date, int amount) {
        return DateUtils.setYears((Date)date, (int)amount);
    }

    public static Date setMonths(@NotNull Date date, int amount) {
        return DateUtils.setMonths((Date)date, (int)amount);
    }

    public static Date setDays(@NotNull Date date, int amount) {
        return DateUtils.setDays((Date)date, (int)amount);
    }

    public static Date setHours(@NotNull Date date, int amount) {
        return DateUtils.setHours((Date)date, (int)amount);
    }

    public static Date setMinutes(@NotNull Date date, int amount) {
        return DateUtils.setMinutes((Date)date, (int)amount);
    }

    public static Date setSeconds(@NotNull Date date, int amount) {
        return DateUtils.setSeconds((Date)date, (int)amount);
    }

    public static Date setMilliseconds(@NotNull Date date, int amount) {
        return DateUtils.setMilliseconds((Date)date, (int)amount);
    }

    public static int getDayOfWeek(@NotNull Date date) {
        int result = DateUtil.getWithMondayFirst(date, 7);
        return result == 1 ? 7 : result - 1;
    }

    public static int getDayOfYear(@NotNull Date date) {
        return DateUtil.get(date, 6);
    }

    public static int getWeekOfMonth(@NotNull Date date) {
        return DateUtil.getWithMondayFirst(date, 4);
    }

    public static int getWeekOfYear(@NotNull Date date) {
        return DateUtil.getWithMondayFirst(date, 3);
    }

    private static int get(Date date, int field) {
        Validate.notNull((Object)date, (String)"The date must not be null", (Object[])new Object[0]);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(field);
    }

    private static int getWithMondayFirst(Date date, int field) {
        Validate.notNull((Object)date, (String)"The date must not be null", (Object[])new Object[0]);
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setTime(date);
        return cal.get(field);
    }

    public static Date beginOfYear(@NotNull Date date) {
        return DateUtils.truncate((Date)date, (int)1);
    }

    public static Date endOfYear(@NotNull Date date) {
        return new Date(DateUtil.nextYear(date).getTime() - 1L);
    }

    public static Date nextYear(@NotNull Date date) {
        return DateUtils.ceiling((Date)date, (int)1);
    }

    public static Date beginOfMonth(@NotNull Date date) {
        return DateUtils.truncate((Date)date, (int)2);
    }

    public static Date endOfMonth(@NotNull Date date) {
        return new Date(DateUtil.nextMonth(date).getTime() - 1L);
    }

    public static Date nextMonth(@NotNull Date date) {
        return DateUtils.ceiling((Date)date, (int)2);
    }

    public static Date beginOfWeek(@NotNull Date date) {
        return DateUtils.truncate((Date)DateUtil.subDays(date, DateUtil.getDayOfWeek(date) - 1), (int)5);
    }

    public static Date endOfWeek(@NotNull Date date) {
        return new Date(DateUtil.nextWeek(date).getTime() - 1L);
    }

    public static Date nextWeek(@NotNull Date date) {
        return DateUtils.truncate((Date)DateUtil.addDays(date, 8 - DateUtil.getDayOfWeek(date)), (int)5);
    }

    public static Date beginOfDate(@NotNull Date date) {
        return DateUtils.truncate((Date)date, (int)5);
    }

    public static Date endOfDate(@NotNull Date date) {
        return new Date(DateUtil.nextDate(date).getTime() - 1L);
    }

    public static Date nextDate(@NotNull Date date) {
        return DateUtils.ceiling((Date)date, (int)5);
    }

    public static Date beginOfHour(@NotNull Date date) {
        return DateUtils.truncate((Date)date, (int)11);
    }

    public static Date endOfHour(@NotNull Date date) {
        return new Date(DateUtil.nextHour(date).getTime() - 1L);
    }

    public static Date nextHour(@NotNull Date date) {
        return DateUtils.ceiling((Date)date, (int)11);
    }

    public static Date beginOfMinute(@NotNull Date date) {
        return DateUtils.truncate((Date)date, (int)12);
    }

    public static Date endOfMinute(@NotNull Date date) {
        return new Date(DateUtil.nextMinute(date).getTime() - 1L);
    }

    public static Date nextMinute(@NotNull Date date) {
        return DateUtils.ceiling((Date)date, (int)12);
    }

    public static boolean isLeapYear(@NotNull Date date) {
        return DateUtil.isLeapYear(DateUtil.get(date, 1));
    }

    public static boolean isLeapYear(int y) {
        boolean result = false;
        if (y % 4 == 0 && (y < 1582 || y % 100 != 0 || y % 400 == 0)) {
            result = true;
        }
        return result;
    }

    public static int getMonthLength(@NotNull Date date) {
        int year = DateUtil.get(date, 1);
        int month = DateUtil.get(date, 2);
        return DateUtil.getMonthLength(year, month);
    }

    public static int getMonthLength(int year, int month) {
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Invalid month: " + month);
        }
        if (month == 2) {
            return DateUtil.isLeapYear(year) ? 29 : 28;
        }
        return MONTH_LENGTH[month];
    }
}

