/*
 * Decompiled with CFR 0.152.
 */
package com.vip.vjtools.vjkit.collection;

import com.google.common.collect.Sets;
import com.vip.vjtools.vjkit.base.annotation.Nullable;
import com.vip.vjtools.vjkit.collection.type.ConcurrentHashSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SetUtil {
    public static <T> HashSet<T> newHashSet() {
        return new HashSet();
    }

    public static <T> HashSet<T> newHashSet(T ... elements) {
        return Sets.newHashSet((Object[])elements);
    }

    public static <T> HashSet<T> newHashSet(Iterable<? extends T> elements) {
        return Sets.newHashSet(elements);
    }

    public static <T> HashSet<T> newHashSetWithCapacity(int expectedSize) {
        return Sets.newHashSetWithExpectedSize((int)expectedSize);
    }

    public static <T extends Comparable> TreeSet<T> newSortedSet() {
        return new TreeSet();
    }

    public static <T> TreeSet<T> newSortedSet(@Nullable Comparator<? super T> comparator) {
        return Sets.newTreeSet(comparator);
    }

    public static <T> ConcurrentHashSet<T> newConcurrentHashSet() {
        return new ConcurrentHashSet();
    }

    public static final <T> Set<T> emptySet() {
        return Collections.emptySet();
    }

    public static <T> Set<T> emptySetIfNull(Set<T> set) {
        return set == null ? Collections.EMPTY_SET : set;
    }

    public static final <T> Set<T> singletonSet(T o) {
        return Collections.singleton(o);
    }

    public static <T> Set<T> unmodifiableSet(Set<? extends T> s) {
        return Collections.unmodifiableSet(s);
    }

    public static <T> Set<T> newSetFromMap(Map<T, Boolean> map) {
        return Collections.newSetFromMap(map);
    }

    public static <E> Set<E> unionView(Set<? extends E> set1, Set<? extends E> set2) {
        return Sets.union(set1, set2);
    }

    public static <E> Set<E> intersectionView(Set<E> set1, Set<?> set2) {
        return Sets.intersection(set1, set2);
    }

    public static <E> Set<E> differenceView(Set<E> set1, Set<?> set2) {
        return Sets.difference(set1, set2);
    }

    public static <E> Set<E> disjointView(Set<? extends E> set1, Set<? extends E> set2) {
        return Sets.symmetricDifference(set1, set2);
    }
}

