/*
 * Decompiled with CFR 0.152.
 */
package com.vip.vjtools.vjkit.collection.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

public final class SortedArrayList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = -8301136559614447593L;
    protected final Comparator<? super E> comparator;

    public SortedArrayList(Comparator<? super E> c) {
        this.comparator = c;
    }

    public SortedArrayList() {
        this.comparator = null;
    }

    public SortedArrayList(Collection<? extends E> c) {
        this.comparator = null;
        this.addAll(c);
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    @Override
    public boolean add(E o) {
        int idx = 0;
        if (!this.isEmpty()) {
            idx = this.findInsertionPoint(o);
        }
        super.add(idx, o);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Iterator<E> i = c.iterator();
        boolean changed = false;
        while (i.hasNext()) {
            boolean ret = this.add(i.next());
            if (changed) continue;
            changed = ret;
        }
        return changed;
    }

    public int findInsertionPoint(E o) {
        return this.findInsertionPoint(o, 0, this.size() - 1);
    }

    @Override
    @Deprecated
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    protected int compare(E k1, E k2) {
        if (this.comparator == null) {
            return ((Comparable)k1).compareTo(k2);
        }
        return this.comparator.compare(k1, k2);
    }

    protected int findInsertionPoint(E o, int originalLow, int originalHigh) {
        int low = originalLow;
        int high = originalHigh;
        while (low <= high) {
            int mid = low + (high - low >>> 1);
            int delta = this.compare(this.get(mid), o);
            if (delta > 0) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return low;
    }
}

