/*
 * Decompiled with CFR 0.152.
 */
package com.vip.vjtools.vjkit.concurrent.limiter;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class TimeIntervalLimiter {
    private final AtomicLong lastTimeAtom = new AtomicLong(0L);
    private long windowSizeMillis;

    public TimeIntervalLimiter(long interval, TimeUnit timeUnit) {
        this.windowSizeMillis = timeUnit.toMillis(interval);
    }

    public boolean tryAcquire() {
        long lastTime;
        long currentTime = System.currentTimeMillis();
        return currentTime - (lastTime = this.lastTimeAtom.get()) >= this.windowSizeMillis && this.lastTimeAtom.compareAndSet(lastTime, currentTime);
    }
}

