/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.footnotes.internal;

import com.vladsch.flexmark.ext.footnotes.Footnote;
import com.vladsch.flexmark.ext.footnotes.FootnoteBlock;
import com.vladsch.flexmark.ext.footnotes.FootnoteExtension;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteOptions;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteRepository;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.PhasedNodeRenderer;
import com.vladsch.flexmark.html.renderer.RenderingPhase;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeVisitor;
import com.vladsch.flexmark.util.ast.VisitHandler;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FootnoteNodeRenderer
implements PhasedNodeRenderer {
    private final FootnoteRepository footnoteRepository;
    private final FootnoteOptions options;
    private final boolean recheckUndefinedReferences;

    public FootnoteNodeRenderer(DataHolder options) {
        this.options = new FootnoteOptions(options);
        this.footnoteRepository = (FootnoteRepository)((Object)FootnoteExtension.FOOTNOTES.get(options));
        this.recheckUndefinedReferences = (Boolean)HtmlRenderer.RECHECK_UNDEFINED_REFERENCES.get(options);
        this.footnoteRepository.resolveFootnoteOrdinals();
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        return new HashSet(Arrays.asList(new NodeRenderingHandler(Footnote.class, this::render), new NodeRenderingHandler(FootnoteBlock.class, this::render)));
    }

    public Set<RenderingPhase> getRenderingPhases() {
        HashSet<RenderingPhase> set = new HashSet<RenderingPhase>();
        set.add(RenderingPhase.BODY_TOP);
        set.add(RenderingPhase.BODY_BOTTOM);
        return set;
    }

    public void renderDocument(@NotNull NodeRendererContext context, @NotNull HtmlWriter html, @NotNull Document document, @NotNull RenderingPhase phase) {
        if (phase == RenderingPhase.BODY_TOP && this.recheckUndefinedReferences) {
            boolean[] hadNewFootnotes = new boolean[]{false};
            NodeVisitor visitor = new NodeVisitor(new VisitHandler[]{new VisitHandler(Footnote.class, node -> {
                FootnoteBlock footonoteBlock;
                if (!node.isDefined() && (footonoteBlock = node.getFootnoteBlock(this.footnoteRepository)) != null) {
                    this.footnoteRepository.addFootnoteReference(footonoteBlock, (Footnote)node);
                    node.setFootnoteBlock(footonoteBlock);
                    hadNewFootnotes[0] = true;
                }
            })});
            visitor.visit((Node)document);
            if (hadNewFootnotes[0]) {
                this.footnoteRepository.resolveFootnoteOrdinals();
            }
        }
        if (phase == RenderingPhase.BODY_BOTTOM && this.footnoteRepository.getReferencedFootnoteBlocks().size() > 0) {
            ((HtmlWriter)html.attr((CharSequence)"class", (CharSequence)"footnotes")).withAttr().tagIndent((CharSequence)"div", () -> {
                html.tagVoidLine((CharSequence)"hr");
                html.tagIndent((CharSequence)"ol", () -> {
                    for (FootnoteBlock footnoteBlock : this.footnoteRepository.getReferencedFootnoteBlocks()) {
                        int footnoteOrdinal = footnoteBlock.getFootnoteOrdinal();
                        html.attr((CharSequence)"id", (CharSequence)("fn-" + footnoteOrdinal));
                        html.withAttr().tagIndent((CharSequence)"li", () -> {
                            context.renderChildren((Node)footnoteBlock);
                            int iMax = footnoteBlock.getFootnoteReferences();
                            for (int i = 0; i < iMax; ++i) {
                                html.attr((CharSequence)"href", (CharSequence)("#fnref-" + footnoteOrdinal + (i == 0 ? "" : String.format(Locale.US, "-%d", i))));
                                if (!this.options.footnoteBackLinkRefClass.isEmpty()) {
                                    html.attr((CharSequence)"class", (CharSequence)this.options.footnoteBackLinkRefClass);
                                }
                                ((HtmlWriter)html.line()).withAttr().tag((CharSequence)"a");
                                html.raw((CharSequence)this.options.footnoteBackRefString);
                                html.tag((CharSequence)"/a");
                            }
                        });
                    }
                });
            });
        }
    }

    private void render(FootnoteBlock node, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(Footnote node, NodeRendererContext context, HtmlWriter html) {
        FootnoteBlock footnoteBlock = node.getFootnoteBlock();
        if (footnoteBlock == null) {
            html.raw((CharSequence)"[^");
            context.renderChildren((Node)node);
            html.raw((CharSequence)"]");
        } else {
            int footnoteOrdinal = footnoteBlock.getFootnoteOrdinal();
            int i = node.getReferenceOrdinal();
            html.attr((CharSequence)"id", (CharSequence)("fnref-" + footnoteOrdinal + (i == 0 ? "" : String.format(Locale.US, "-%d", i))));
            html.srcPos(node.getChars()).withAttr().tag((CharSequence)"sup", false, false, () -> {
                if (!this.options.footnoteLinkRefClass.isEmpty()) {
                    html.attr((CharSequence)"class", (CharSequence)this.options.footnoteLinkRefClass);
                }
                html.attr((CharSequence)"href", (CharSequence)("#fn-" + footnoteOrdinal));
                html.withAttr().tag((CharSequence)"a");
                html.raw((CharSequence)(this.options.footnoteRefPrefix + footnoteOrdinal + this.options.footnoteRefSuffix));
                html.tag((CharSequence)"/a");
            });
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new FootnoteNodeRenderer(options);
        }
    }
}

