/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.rpc;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import java.util.HashMap;
import java.util.Map;

public class RpcContext {
    private Map<Object, Object> attribute = new HashMap<Object, Object>();
    private Request request;
    private Response response;
    private String clientRequestId = null;
    private static final ThreadLocal<RpcContext> localContext = new ThreadLocal<RpcContext>(){

        @Override
        protected RpcContext initialValue() {
            return new RpcContext();
        }
    };

    public static RpcContext getContext() {
        return localContext.get();
    }

    public static RpcContext init(Request request) {
        RpcContext context = new RpcContext();
        if (request != null) {
            context.setRequest(request);
            context.setClientRequestId(request.getAttachments().get(URLParamType.requestIdFromClient.getName()));
        }
        localContext.set(context);
        return context;
    }

    public static void destroy() {
        localContext.remove();
    }

    public String getRequestId() {
        if (this.clientRequestId != null) {
            return this.clientRequestId;
        }
        return this.request == null ? null : String.valueOf(this.request.getRequestId());
    }

    public void putAttribute(Object key, Object value) {
        this.attribute.put(key, value);
    }

    public Object getAttribute(Object key) {
        return this.attribute.get(key);
    }

    public void revomeAttribute(Object key) {
        this.attribute.remove(key);
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public String getClientRequestId() {
        return this.clientRequestId;
    }

    public void setClientRequestId(String clientRequestId) {
        this.clientRequestId = clientRequestId;
    }
}

