/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.filter;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.filter.Filter;
import com.weibo.api.motan.rpc.Callbackable;
import com.weibo.api.motan.rpc.Caller;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.Traceable;
import com.weibo.api.motan.util.ExceptionUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import com.weibo.api.motan.util.StatsUtil;

@SpiMeta(name="statistic")
public class AccessStatisticFilter
implements Filter {
    private static final String RPC_SERVICE = "rpc_service";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response filter(Caller<?> caller, Request request) {
        long start = System.currentTimeMillis();
        StatsUtil.AccessStatus accessStatus = StatsUtil.AccessStatus.NORMAL;
        Response response = null;
        try {
            response = caller.call(request);
            if (response != null && response.getException() != null) {
                accessStatus = ExceptionUtil.isBizException(response.getException()) ? StatsUtil.AccessStatus.BIZ_EXCEPTION : StatsUtil.AccessStatus.OTHER_EXCEPTION;
            }
            Response response2 = response;
            return response2;
        }
        finally {
            String module;
            String application;
            long bizProcessTime;
            long end = System.currentTimeMillis();
            if (response == null) {
                accessStatus = StatsUtil.AccessStatus.OTHER_EXCEPTION;
                bizProcessTime = end - start;
            } else {
                bizProcessTime = response.getProcessTime();
            }
            if (caller instanceof Referer) {
                application = request.getAttachments().get(URLParamType.application.getName());
                module = MotanFrameworkUtil.getModuleOrGroup(request.getAttachments(), null);
            } else {
                application = caller.getUrl().getApplication();
                module = MotanFrameworkUtil.getModuleOrGroup(caller.getUrl().getParameters(), null);
            }
            String statName = caller.getUrl().getProtocol() + "://" + MotanFrameworkUtil.getGroupMethodString(request);
            int slowCost = caller.getUrl().getIntParameter(URLParamType.slowThreshold.getName(), URLParamType.slowThreshold.getIntValue());
            Response finalResponse = response;
            if (caller instanceof Provider) {
                StatsUtil.accessStatistic(statName, "statisitic", RPC_SERVICE, end, end - start, bizProcessTime, slowCost, accessStatus);
                if (response instanceof Callbackable) {
                    StatsUtil.AccessStatus finalAccessStatus = accessStatus;
                    ((Callbackable)((Object)response)).addFinishCallback(() -> {
                        if (request instanceof Traceable && finalResponse instanceof Traceable) {
                            long responseSend = ((Traceable)((Object)finalResponse)).getTraceableContext().getSendTime();
                            long requestReceive = ((Traceable)((Object)request)).getTraceableContext().getReceiveTime();
                            StatsUtil.accessStatistic(statName + "_WHOLE", application, module, responseSend, responseSend - requestReceive, bizProcessTime, slowCost, finalAccessStatus);
                        }
                    }, null);
                }
            }
            StatsUtil.accessStatistic(statName, application, module, end, end - start, bizProcessTime, slowCost, accessStatus);
        }
    }
}

