/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol;

import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.rpc.Exporter;
import com.weibo.api.motan.rpc.Node;
import com.weibo.api.motan.rpc.Protocol;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractProtocol
implements Protocol {
    protected ConcurrentHashMap<String, Exporter<?>> exporterMap = new ConcurrentHashMap();

    public Map<String, Exporter<?>> getExporterMap() {
        return Collections.unmodifiableMap(this.exporterMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Exporter<T> export(Provider<T> provider, URL url) {
        if (url == null) {
            throw new MotanFrameworkException(this.getClass().getSimpleName() + " export Error: url is null", MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
        }
        if (provider == null) {
            throw new MotanFrameworkException(this.getClass().getSimpleName() + " export Error: provider is null, url=" + url, MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
        }
        String protocolKey = MotanFrameworkUtil.getProtocolKey(url);
        ConcurrentHashMap<String, Exporter<?>> concurrentHashMap = this.exporterMap;
        synchronized (concurrentHashMap) {
            Exporter<Object> exporter = this.exporterMap.get(protocolKey);
            if (exporter != null) {
                throw new MotanFrameworkException(this.getClass().getSimpleName() + " export Error: service already exist, url=" + url, MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
            }
            exporter = this.createExporter(provider, url);
            exporter.init();
            protocolKey = MotanFrameworkUtil.getProtocolKey(url);
            this.exporterMap.put(protocolKey, exporter);
            LoggerUtil.info(this.getClass().getSimpleName() + " export Success: url=" + url);
            return exporter;
        }
    }

    public <T> Referer<T> refer(Class<T> clz, URL url) {
        return this.refer(clz, url, url);
    }

    @Override
    public <T> Referer<T> refer(Class<T> clz, URL url, URL serviceUrl) {
        if (url == null) {
            throw new MotanFrameworkException(this.getClass().getSimpleName() + " refer Error: url is null", MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
        }
        if (clz == null) {
            throw new MotanFrameworkException(this.getClass().getSimpleName() + " refer Error: class is null, url=" + url, MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
        }
        long start = System.currentTimeMillis();
        Referer<T> referer = this.createReferer(clz, url, serviceUrl);
        referer.init();
        LoggerUtil.info(this.getClass().getSimpleName() + " refer Success: url=" + url + ", cost:" + (System.currentTimeMillis() - start));
        return referer;
    }

    protected abstract <T> Exporter<T> createExporter(Provider<T> var1, URL var2);

    protected abstract <T> Referer<T> createReferer(Class<T> var1, URL var2, URL var3);

    @Override
    public void destroy() {
        for (String key : this.exporterMap.keySet()) {
            Node node = this.exporterMap.remove(key);
            if (node == null) continue;
            try {
                node.destroy();
                LoggerUtil.info(this.getClass().getSimpleName() + " destroy node Success: " + node);
            }
            catch (Throwable t) {
                LoggerUtil.error(this.getClass().getSimpleName() + " destroy Error", t);
            }
        }
    }
}

