/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.proxy;

import com.weibo.api.motan.cluster.Cluster;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.proxy.AbstractRefererHandler;
import com.weibo.api.motan.rpc.DefaultRequest;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;

public class RefererInvocationHandler<T>
extends AbstractRefererHandler<T>
implements InvocationHandler {
    public RefererInvocationHandler(Class<T> clz, List<Cluster<T>> clusters) {
        this.clz = clz;
        this.clusters = clusters;
        this.init();
        this.interfaceName = MotanFrameworkUtil.removeAsyncSuffix(clz.getName());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isLocalMethod(method)) {
            if ("toString".equals(method.getName())) {
                return this.clustersToString();
            }
            if ("equals".equals(method.getName())) {
                return this.proxyEquals(args[0]);
            }
            if ("hashCode".equals(method.getName())) {
                return this.clusters == null ? 0 : this.clusters.hashCode();
            }
            throw new MotanServiceException("can not invoke local method:" + method.getName());
        }
        DefaultRequest request = new DefaultRequest();
        boolean async = this.fillDefaultRequest(request, method, args);
        return this.invokeRequest(request, this.getRealReturnType(async, this.clz, method, request.getMethodName()), async);
    }

    private String clustersToString() {
        StringBuilder sb = new StringBuilder();
        for (Cluster cluster : this.clusters) {
            sb.append("{protocol:").append(cluster.getUrl().getProtocol());
            List referers = cluster.getReferers();
            if (referers != null) {
                for (Referer refer : referers) {
                    sb.append("[").append(refer.getUrl().toSimpleString()).append(", available:").append(refer.isAvailable()).append("]");
                }
            }
            sb.append("}");
        }
        return sb.toString();
    }

    private boolean proxyEquals(Object o) {
        if (o == null || this.clusters == null) {
            return false;
        }
        if (o instanceof List) {
            return this.clusters == o;
        }
        return o.equals(this.clusters);
    }
}

