/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.convert.impl;

import com.xiaoleilu.hutool.convert.AbstractConverter;
import com.xiaoleilu.hutool.convert.ConvertException;
import com.xiaoleilu.hutool.util.StrUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class NumberConverter
extends AbstractConverter<Number> {
    private Class<? extends Number> targetType;

    public NumberConverter() {
        this.targetType = Number.class;
    }

    public NumberConverter(Class<? extends Number> clazz) {
        this.targetType = null == clazz ? Number.class : clazz;
    }

    @Override
    protected Number convertInternal(Object value) {
        if (Byte.class == this.targetType) {
            if (value instanceof Number) {
                return ((Number)value).byteValue();
            }
            String valueStr = this.convertToStr(value);
            if (StrUtil.isBlank(valueStr)) {
                return null;
            }
            return Byte.valueOf(valueStr);
        }
        if (Short.class == this.targetType) {
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            String valueStr = this.convertToStr(value);
            if (StrUtil.isBlank(valueStr)) {
                return null;
            }
            return Short.valueOf(valueStr);
        }
        if (Integer.class == this.targetType) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            String valueStr2 = this.convertToStr(value);
            if (StrUtil.isBlank(valueStr2)) {
                return null;
            }
            return Integer.valueOf(valueStr2);
        }
        if (AtomicInteger.class == this.targetType) {
            String valueStr;
            if (value instanceof Number) {
                int valueStr2 = ((Number)value).intValue();
            }
            if (StrUtil.isBlank(valueStr = this.convertToStr(value))) {
                return null;
            }
            int intValue = Integer.parseInt(valueStr);
            return new AtomicInteger(intValue);
        }
        if (Long.class == this.targetType) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            String valueStr3 = this.convertToStr(value);
            if (StrUtil.isBlank(valueStr3)) {
                return null;
            }
            return Long.valueOf(valueStr3);
        }
        if (AtomicLong.class == this.targetType) {
            String valueStr;
            if (value instanceof Number) {
                long valueStr3 = ((Number)value).longValue();
            }
            if (StrUtil.isBlank(valueStr = this.convertToStr(value))) {
                return null;
            }
            long longValue = Long.parseLong(valueStr);
            return new AtomicLong(longValue);
        }
        if (Float.class == this.targetType) {
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            String valueStr = this.convertToStr(value);
            if (StrUtil.isBlank(valueStr)) {
                return null;
            }
            return Float.valueOf(valueStr);
        }
        if (Double.class == this.targetType) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            String valueStr = this.convertToStr(value);
            if (StrUtil.isBlank(valueStr)) {
                return null;
            }
            return Double.valueOf(valueStr);
        }
        if (BigDecimal.class == this.targetType) {
            return this.toBigDecimal(value);
        }
        if (BigInteger.class == this.targetType) {
            this.toBigInteger(value);
        } else if (Number.class == this.targetType) {
            if (value instanceof Number) {
                return (Number)value;
            }
            String valueStr = this.convertToStr(value);
            if (StrUtil.isBlank(valueStr)) {
                return null;
            }
            try {
                return NumberFormat.getInstance().parse(valueStr);
            }
            catch (ParseException e) {
                throw new ConvertException(e);
            }
        }
        throw new UnsupportedOperationException(StrUtil.format((CharSequence)"Unsupport Number type: {}", this.targetType.getName()));
    }

    private BigDecimal toBigDecimal(Object value) {
        if (value instanceof Long) {
            return new BigDecimal((Long)value);
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        String valueStr = this.convertToStr(value);
        if (StrUtil.isBlank(valueStr)) {
            return null;
        }
        return new BigDecimal(valueStr);
    }

    private BigInteger toBigInteger(Object value) {
        if (value instanceof Long) {
            return BigInteger.valueOf((Long)value);
        }
        String valueStr = this.convertToStr(value);
        if (StrUtil.isBlank(valueStr)) {
            return null;
        }
        return new BigInteger(valueStr);
    }

    @Override
    protected String convertToStr(Object value) {
        String valueStr = super.convertToStr(value);
        return null == valueStr ? null : valueStr.trim();
    }

    @Override
    public Class<Number> getTargetType() {
        return this.targetType;
    }
}

