/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.crypto.symmetric;

import com.xiaoleilu.hutool.crypto.Mode;
import com.xiaoleilu.hutool.crypto.Padding;
import com.xiaoleilu.hutool.crypto.SecureUtil;
import com.xiaoleilu.hutool.crypto.symmetric.SymmetricAlgorithm;
import com.xiaoleilu.hutool.crypto.symmetric.SymmetricCrypto;
import com.xiaoleilu.hutool.util.StrUtil;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class DES
extends SymmetricCrypto {
    public DES() {
        super(SymmetricAlgorithm.DES);
    }

    public DES(byte[] key) {
        super(SymmetricAlgorithm.DES, key);
    }

    public DES(Mode mode, Padding padding) {
        this(mode.name(), padding.name());
    }

    public DES(Mode mode, Padding padding, byte[] key) {
        this(mode, padding, key, null);
    }

    public DES(Mode mode, Padding padding, byte[] key, byte[] iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public DES(Mode mode, Padding padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public DES(Mode mode, Padding padding, SecretKey key, IvParameterSpec iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public DES(String mode, String padding) {
        this(mode, padding, (byte[])null);
    }

    public DES(String mode, String padding, byte[] key) {
        this(mode, padding, SecureUtil.generateKey("DES", key), null);
    }

    public DES(String mode, String padding, byte[] key, byte[] iv) {
        this(mode, padding, SecureUtil.generateKey("DES", key), null == iv ? null : new IvParameterSpec(iv));
    }

    public DES(String mode, String padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public DES(String mode, String padding, SecretKey key, IvParameterSpec iv) {
        super(StrUtil.format((CharSequence)"DES/{}/{}", mode, padding), key, iv);
    }

    public DES setIv(IvParameterSpec iv) {
        super.setParams(iv);
        return this;
    }

    public DES setIv(byte[] iv) {
        this.setIv(new IvParameterSpec(iv));
        return this;
    }
}

