/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.lang;

import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.io.FileUtil;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.util.ClassUtil;
import com.xiaoleilu.hutool.util.ReflectUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;

public class JarClassLoader
extends URLClassLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JarClassLoader loadJar(File jarFile) {
        JarClassLoader loader = new JarClassLoader();
        try {
            loader.addJar(jarFile);
        }
        finally {
            IoUtil.close(loader);
        }
        return loader;
    }

    public static void loadJar(URLClassLoader loader, File jarFile) throws UtilException {
        try {
            Method method = ClassUtil.getDeclaredMethod(URLClassLoader.class, "addURL", URL.class);
            if (null != method) {
                method.setAccessible(true);
                List<File> jars = JarClassLoader.loopJar(jarFile);
                for (File jar : jars) {
                    ReflectUtil.invoke((Object)loader, method, jar.toURI().toURL());
                }
            }
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
    }

    public static URLClassLoader loadJarToSystemClassLoader(File jarFile) {
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        JarClassLoader.loadJar(urlClassLoader, jarFile);
        return urlClassLoader;
    }

    public JarClassLoader() {
        this(new URL[0]);
    }

    public JarClassLoader(URL[] urls) {
        super(urls, ClassUtil.getClassLoader());
    }

    public JarClassLoader addJar(File jarFile) {
        List<File> jars = JarClassLoader.loopJar(jarFile);
        try {
            for (File jar : jars) {
                super.addURL(jar.toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new UtilException(e);
        }
        return this;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    private static List<File> loopJar(File file) {
        return FileUtil.loopFiles(file, new FileFilter(){

            @Override
            public boolean accept(File file) {
                String path = file.getPath();
                return path != null && path.toLowerCase().endsWith(".jar");
            }
        });
    }
}

