/*
 * Decompiled with CFR 0.152.
 */
package com.xingyuv.jushauth.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xingyuv.jushauth.cache.AuthStateCache;
import com.xingyuv.jushauth.config.AuthConfig;
import com.xingyuv.jushauth.config.AuthSource;
import com.xingyuv.jushauth.enums.AuthUserGender;
import com.xingyuv.jushauth.exception.AuthException;
import com.xingyuv.jushauth.model.AuthCallback;
import com.xingyuv.jushauth.model.AuthToken;
import com.xingyuv.jushauth.model.AuthUser;
import com.xingyuv.jushauth.request.AuthDefaultRequest;
import com.xingyuv.jushauth.utils.GlobalAuthUtils;
import com.xingyuv.jushauth.utils.HttpUtils;
import com.xingyuv.jushauth.utils.UrlBuilder;

public abstract class AbstractAuthDingtalkRequest
extends AuthDefaultRequest {
    public AbstractAuthDingtalkRequest(AuthConfig config, AuthSource source) {
        super(config, source);
    }

    public AbstractAuthDingtalkRequest(AuthConfig config, AuthSource source, AuthStateCache authStateCache) {
        super(config, source, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        return AuthToken.builder().accessCode(authCallback.getCode()).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String code = authToken.getAccessCode();
        JSONObject param = new JSONObject();
        param.put("tmp_auth_code", (Object)code);
        String response = new HttpUtils(this.config.getHttpConfig()).post(this.userInfoUrl(authToken), param.toJSONString()).getBody();
        JSONObject object = JSON.parseObject((String)response);
        if (object.getIntValue("errcode") != 0) {
            throw new AuthException(object.getString("errmsg"));
        }
        object = object.getJSONObject("user_info");
        AuthToken token = AuthToken.builder().openId(object.getString("openid")).unionId(object.getString("unionid")).build();
        return AuthUser.builder().rawUserInfo(object).uuid(object.getString("unionid")).nickname(object.getString("nick")).username(object.getString("nick")).gender(AuthUserGender.UNKNOWN).source(this.source.toString()).token(token).build();
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("appid", this.config.getClientId()).queryParam("scope", "snsapi_login").queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("state", this.getRealState(state)).build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        String timestamp = String.valueOf(System.currentTimeMillis());
        String urlEncodeSignature = GlobalAuthUtils.generateDingTalkSignature(this.config.getClientSecret(), timestamp);
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("signature", urlEncodeSignature).queryParam("timestamp", timestamp).queryParam("accessKey", this.config.getClientId()).build();
    }
}

