/*
 * Decompiled with CFR 0.152.
 */
package com.xingyuv.jushauth.request;

import com.alibaba.fastjson.JSONObject;
import com.xingyuv.http.support.HttpHeader;
import com.xingyuv.http.util.MapUtil;
import com.xingyuv.jushauth.cache.AuthStateCache;
import com.xingyuv.jushauth.config.AuthConfig;
import com.xingyuv.jushauth.config.AuthDefaultSource;
import com.xingyuv.jushauth.enums.AuthUserGender;
import com.xingyuv.jushauth.enums.scope.AuthStackoverflowScope;
import com.xingyuv.jushauth.exception.AuthException;
import com.xingyuv.jushauth.model.AuthCallback;
import com.xingyuv.jushauth.model.AuthToken;
import com.xingyuv.jushauth.model.AuthUser;
import com.xingyuv.jushauth.request.AuthDefaultRequest;
import com.xingyuv.jushauth.utils.AuthScopeUtils;
import com.xingyuv.jushauth.utils.HttpUtils;
import com.xingyuv.jushauth.utils.UrlBuilder;
import java.util.Map;

public class AuthStackOverflowRequest
extends AuthDefaultRequest {
    public AuthStackOverflowRequest(AuthConfig config) {
        super(config, AuthDefaultSource.STACK_OVERFLOW);
    }

    public AuthStackOverflowRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.STACK_OVERFLOW, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        String accessTokenUrl = this.accessTokenUrl(authCallback.getCode());
        Map form = MapUtil.parseStringToMap((String)accessTokenUrl, (boolean)false);
        HttpHeader httpHeader = new HttpHeader();
        httpHeader.add("Content-Type", "application/x-www-form-urlencoded");
        String response = new HttpUtils(this.config.getHttpConfig()).post(accessTokenUrl, form, httpHeader, false).getBody();
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        this.checkResponse(accessTokenObject);
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).expireIn(accessTokenObject.getIntValue("expires")).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String userInfoUrl = UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("access_token", authToken.getAccessToken()).queryParam("site", "stackoverflow").queryParam("key", this.config.getStackOverflowKey()).build();
        String response = new HttpUtils(this.config.getHttpConfig()).get(userInfoUrl).getBody();
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        JSONObject userObj = object.getJSONArray("items").getJSONObject(0);
        return AuthUser.builder().rawUserInfo(userObj).uuid(userObj.getString("user_id")).avatar(userObj.getString("profile_image")).location(userObj.getString("location")).nickname(userObj.getString("display_name")).blog(userObj.getString("website_url")).gender(AuthUserGender.UNKNOWN).token(authToken).source(this.source.toString()).build();
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(super.authorize(state)).queryParam("scope", this.getScopes(",", false, AuthScopeUtils.getDefaultScopes(AuthStackoverflowScope.values()))).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error")) {
            throw new AuthException(object.getString("error_description"));
        }
    }
}

