/*
 * Decompiled with CFR 0.152.
 */
package com.xingyuv.http.support.hutool;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.xingyuv.http.config.HttpConfig;
import com.xingyuv.http.support.AbstractHttp;
import com.xingyuv.http.support.HttpHeader;
import com.xingyuv.http.support.SimpleHttpResponse;
import com.xingyuv.http.util.MapUtil;
import com.xingyuv.http.util.StringUtil;
import com.xingyuv.http.util.UrlUtil;
import java.util.Map;

public class HutoolImpl
extends AbstractHttp {
    public HutoolImpl() {
        this(new HttpConfig());
    }

    public HutoolImpl(HttpConfig httpConfig) {
        super(httpConfig);
    }

    private SimpleHttpResponse exec(HttpRequest request) {
        SimpleHttpResponse simpleHttpResponse;
        block9: {
            request = request.timeout(this.httpConfig.getTimeout());
            if (null != this.httpConfig.getProxy()) {
                request = request.setProxy(this.httpConfig.getProxy());
            }
            HttpResponse response = request.execute();
            try {
                int code = response.getStatus();
                boolean successful = response.isOk();
                String body = response.body();
                Map headers = response.headers();
                simpleHttpResponse = new SimpleHttpResponse(successful, code, headers, body, null);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return new SimpleHttpResponse(false, 500, null, null, e.getMessage());
                }
            }
            response.close();
        }
        return simpleHttpResponse;
    }

    @Override
    public SimpleHttpResponse get(String url) {
        return this.get(url, null, false);
    }

    @Override
    public SimpleHttpResponse get(String url, Map<String, String> params, boolean encode) {
        return this.get(url, params, null, encode);
    }

    @Override
    public SimpleHttpResponse get(String url, Map<String, String> params, HttpHeader header, boolean encode) {
        String baseUrl = StringUtil.appendIfNotContain((String)url, "?", "&");
        url = baseUrl + MapUtil.parseMapToString(params, encode);
        HttpRequest request = HttpRequest.get((String)url);
        if (header != null) {
            MapUtil.forEach(header.getHeaders(), (arg_0, arg_1) -> ((HttpRequest)request).header(arg_0, arg_1));
        }
        return this.exec(request);
    }

    @Override
    public SimpleHttpResponse post(String url) {
        HttpRequest request = HttpRequest.post((String)url);
        return this.exec(request);
    }

    @Override
    public SimpleHttpResponse post(String url, String data) {
        return this.post(url, data, null);
    }

    @Override
    public SimpleHttpResponse post(String url, String data, HttpHeader header) {
        HttpRequest request = HttpRequest.post((String)url);
        if (StringUtil.isNotEmpty(data)) {
            request.body(data);
        }
        if (header != null) {
            MapUtil.forEach(header.getHeaders(), (arg_0, arg_1) -> ((HttpRequest)request).header(arg_0, arg_1));
        }
        return this.exec(request);
    }

    @Override
    public SimpleHttpResponse post(String url, Map<String, String> params, boolean encode) {
        return this.post(url, params, null, encode);
    }

    @Override
    public SimpleHttpResponse post(String url, Map<String, String> params, HttpHeader header, boolean encode) {
        HttpRequest request = HttpRequest.post((String)url);
        if (encode) {
            MapUtil.forEach(params, (k, v) -> request.form(k, (Object)UrlUtil.urlEncode(v)));
        } else {
            MapUtil.forEach(params, (arg_0, arg_1) -> ((HttpRequest)request).form(arg_0, arg_1));
        }
        if (header != null) {
            MapUtil.forEach(header.getHeaders(), (arg_0, arg_1) -> ((HttpRequest)request).header(arg_0, arg_1));
        }
        return this.exec(request);
    }
}

