/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.thread;

import com.xxl.job.core.biz.AdminBiz;
import com.xxl.job.core.biz.model.HandleCallbackParam;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.context.XxlJobContext;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.executor.XxlJobExecutor;
import com.xxl.job.core.log.XxlJobFileAppender;
import com.xxl.job.core.util.FileUtil;
import com.xxl.job.core.util.JdkSerializeTool;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerCallbackThread {
    private static Logger logger = LoggerFactory.getLogger(TriggerCallbackThread.class);
    private static TriggerCallbackThread instance = new TriggerCallbackThread();
    private LinkedBlockingQueue<HandleCallbackParam> callBackQueue = new LinkedBlockingQueue();
    private Thread triggerCallbackThread;
    private Thread triggerRetryCallbackThread;
    private volatile boolean toStop = false;
    private static String failCallbackFilePath = XxlJobFileAppender.getLogPath().concat(File.separator).concat("callbacklog").concat(File.separator);
    private static String failCallbackFileName = failCallbackFilePath.concat("xxl-job-callback-{x}").concat(".log");

    public static TriggerCallbackThread getInstance() {
        return instance;
    }

    public static void pushCallBack(HandleCallbackParam callback) {
        TriggerCallbackThread.getInstance().callBackQueue.add(callback);
        logger.debug(">>>>>>>>>>> xxl-job, push callback request, logId:{}", (Object)callback.getLogId());
    }

    public void start() {
        if (XxlJobExecutor.getAdminBizList() == null) {
            logger.warn(">>>>>>>>>>> xxl-job, executor callback config fail, adminAddresses is null.");
            return;
        }
        this.triggerCallbackThread = new Thread(new Runnable(){

            @Override
            public void run() {
                block6: {
                    while (!TriggerCallbackThread.this.toStop) {
                        try {
                            HandleCallbackParam callback = TriggerCallbackThread.getInstance().callBackQueue.take();
                            if (callback == null) continue;
                            ArrayList<HandleCallbackParam> callbackParamList = new ArrayList<HandleCallbackParam>();
                            int drainToNum = TriggerCallbackThread.getInstance().callBackQueue.drainTo(callbackParamList);
                            callbackParamList.add(callback);
                            if (callbackParamList == null || callbackParamList.size() <= 0) continue;
                            TriggerCallbackThread.this.doCallback(callbackParamList);
                        }
                        catch (Throwable e) {
                            if (TriggerCallbackThread.this.toStop) continue;
                            logger.error(e.getMessage(), e);
                        }
                    }
                    try {
                        ArrayList<HandleCallbackParam> callbackParamList = new ArrayList<HandleCallbackParam>();
                        int drainToNum = TriggerCallbackThread.getInstance().callBackQueue.drainTo(callbackParamList);
                        if (callbackParamList != null && callbackParamList.size() > 0) {
                            TriggerCallbackThread.this.doCallback(callbackParamList);
                        }
                    }
                    catch (Throwable e) {
                        if (TriggerCallbackThread.this.toStop) break block6;
                        logger.error(e.getMessage(), e);
                    }
                }
                logger.info(">>>>>>>>>>> xxl-job, executor callback thread destroy.");
            }
        });
        this.triggerCallbackThread.setDaemon(true);
        this.triggerCallbackThread.setName("xxl-job, executor TriggerCallbackThread");
        this.triggerCallbackThread.start();
        this.triggerRetryCallbackThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!TriggerCallbackThread.this.toStop) {
                    block5: {
                        try {
                            TriggerCallbackThread.this.retryFailCallbackFile();
                        }
                        catch (Throwable e) {
                            if (TriggerCallbackThread.this.toStop) break block5;
                            logger.error(e.getMessage(), e);
                        }
                    }
                    try {
                        TimeUnit.SECONDS.sleep(30L);
                    }
                    catch (Throwable e) {
                        if (TriggerCallbackThread.this.toStop) continue;
                        logger.error(e.getMessage(), e);
                    }
                }
                logger.info(">>>>>>>>>>> xxl-job, executor retry callback thread destroy.");
            }
        });
        this.triggerRetryCallbackThread.setDaemon(true);
        this.triggerRetryCallbackThread.start();
    }

    public void toStop() {
        this.toStop = true;
        if (this.triggerCallbackThread != null) {
            this.triggerCallbackThread.interrupt();
            try {
                this.triggerCallbackThread.join();
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
        }
        if (this.triggerRetryCallbackThread != null) {
            this.triggerRetryCallbackThread.interrupt();
            try {
                this.triggerRetryCallbackThread.join();
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
        }
    }

    private void doCallback(List<HandleCallbackParam> callbackParamList) {
        boolean callbackRet = false;
        for (AdminBiz adminBiz : XxlJobExecutor.getAdminBizList()) {
            try {
                ReturnT<String> callbackResult = adminBiz.callback(callbackParamList);
                if (callbackResult != null && callbackResult.isSuccess()) {
                    this.callbackLog(callbackParamList, "<br>----------- xxl-job job callback finish.");
                    callbackRet = true;
                    break;
                }
                this.callbackLog(callbackParamList, "<br>----------- xxl-job job callback fail, callbackResult:" + callbackResult);
            }
            catch (Throwable e) {
                this.callbackLog(callbackParamList, "<br>----------- xxl-job job callback error, errorMsg:" + e.getMessage());
            }
        }
        if (!callbackRet) {
            this.appendFailCallbackFile(callbackParamList);
        }
    }

    private void callbackLog(List<HandleCallbackParam> callbackParamList, String logContent) {
        for (HandleCallbackParam callbackParam : callbackParamList) {
            String logFileName = XxlJobFileAppender.makeLogFileName(new Date(callbackParam.getLogDateTim()), callbackParam.getLogId());
            XxlJobContext.setXxlJobContext(new XxlJobContext(-1L, null, logFileName, -1, -1));
            XxlJobHelper.log(logContent, new Object[0]);
        }
    }

    private void appendFailCallbackFile(List<HandleCallbackParam> callbackParamList) {
        if (callbackParamList == null || callbackParamList.size() == 0) {
            return;
        }
        byte[] callbackParamList_bytes = JdkSerializeTool.serialize(callbackParamList);
        File callbackLogFile = new File(failCallbackFileName.replace("{x}", String.valueOf(System.currentTimeMillis())));
        if (callbackLogFile.exists()) {
            for (int i = 0; i < 100 && (callbackLogFile = new File(failCallbackFileName.replace("{x}", String.valueOf(System.currentTimeMillis()).concat("-").concat(String.valueOf(i))))).exists(); ++i) {
            }
        }
        FileUtil.writeFileContent(callbackLogFile, callbackParamList_bytes);
    }

    private void retryFailCallbackFile() {
        File callbackLogPath = new File(failCallbackFilePath);
        if (!callbackLogPath.exists()) {
            return;
        }
        if (callbackLogPath.isFile()) {
            callbackLogPath.delete();
        }
        if (!callbackLogPath.isDirectory() || callbackLogPath.list() == null || callbackLogPath.list().length <= 0) {
            return;
        }
        for (File callbackLogFile : callbackLogPath.listFiles()) {
            byte[] callbackParamList_bytes = FileUtil.readFileContent(callbackLogFile);
            if (callbackParamList_bytes == null || callbackParamList_bytes.length < 1) {
                callbackLogFile.delete();
                continue;
            }
            List callbackParamList = (List)JdkSerializeTool.deserialize(callbackParamList_bytes, List.class);
            callbackLogFile.delete();
            this.doCallback(callbackParamList);
        }
    }
}

