/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.registry.impl;

import com.xxl.rpc.registry.ServiceRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class LocalServiceRegistry
extends ServiceRegistry {
    private Map<String, TreeSet<String>> registryData;

    @Override
    public void start(Map<String, String> param) {
        this.registryData = new HashMap<String, TreeSet<String>>();
    }

    @Override
    public void stop() {
        this.registryData.clear();
    }

    @Override
    public boolean registry(String key, String value) {
        if (key == null || key.trim().length() == 0 || value == null || value.trim().length() == 0) {
            return false;
        }
        TreeSet<String> values = this.registryData.get(key);
        if (values == null) {
            values = new TreeSet();
            this.registryData.put(key, values);
        }
        values.add(value);
        return true;
    }

    @Override
    public boolean remove(String key, String value) {
        TreeSet<String> values = this.registryData.get(key);
        if (values != null) {
            values.remove(value);
        }
        return true;
    }

    @Override
    public TreeSet<String> discovery(String key) {
        return this.registryData.get(key);
    }
}

