/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.invoker.call;

import com.xxl.rpc.remoting.net.params.XxlRpcFutureResponse;
import com.xxl.rpc.remoting.net.params.XxlRpcFutureResponseFactory;
import com.xxl.rpc.remoting.net.params.XxlRpcResponse;
import com.xxl.rpc.util.XxlRpcException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class XxlRpcInvokeFuture
implements Future {
    private XxlRpcFutureResponse futureResponse;
    private static ThreadLocal<XxlRpcInvokeFuture> threadInvokerFuture = new ThreadLocal();

    public XxlRpcInvokeFuture(XxlRpcFutureResponse futureResponse) {
        this.futureResponse = futureResponse;
    }

    public void stop() {
        XxlRpcFutureResponseFactory.removeInvokerFuture(this.futureResponse.getRequest().getRequestId());
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.futureResponse.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.futureResponse.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.futureResponse.isDone();
    }

    public Object get() throws ExecutionException, InterruptedException {
        try {
            return this.get(-1L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new XxlRpcException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            XxlRpcResponse xxlRpcResponse = this.futureResponse.get(timeout, unit);
            if (xxlRpcResponse.getErrorMsg() != null) {
                throw new XxlRpcException(xxlRpcResponse.getErrorMsg());
            }
            Object object = xxlRpcResponse.getResult();
            return object;
        }
        finally {
            this.stop();
        }
    }

    public static <T> Future<T> getFuture(Class<T> type) {
        Future future = threadInvokerFuture.get();
        threadInvokerFuture.remove();
        return future;
    }

    public static void setFuture(XxlRpcInvokeFuture future) {
        threadInvokerFuture.set(future);
    }

    public static void removeFuture() {
        threadInvokerFuture.remove();
    }
}

