/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.net.impl.mina.codec;

import com.xxl.rpc.serialize.Serializer;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;

public class MinaDecoder
extends CumulativeProtocolDecoder {
    private Class<?> genericClass;
    private Serializer serializer;

    public MinaDecoder(Class<?> genericClass, Serializer serializer) {
        this.genericClass = genericClass;
        this.serializer = serializer;
    }

    protected boolean doDecode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        if (in.remaining() < 4) {
            return false;
        }
        in.mark();
        int dataLength = in.getInt();
        if (dataLength < in.remaining()) {
            return false;
        }
        if (dataLength > in.remaining()) {
            in.reset();
        }
        byte[] datas = new byte[dataLength];
        in.get(datas, 0, dataLength);
        Object obj = this.serializer.deserialize(datas, this.genericClass);
        out.write(obj);
        return true;
    }
}

