/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.auth.credentials.provider;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.base.auth.credentials.provider.YopBaseCredentialsProvider;
import com.yeepay.yop.sdk.base.config.YopAppConfig;
import com.yeepay.yop.sdk.config.provider.file.YopCertConfig;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import java.util.List;
import java.util.Map;

public abstract class YopFixedCredentialsProvider
extends YopBaseCredentialsProvider {
    private final Map<String, YopAppConfig> appConfigs = Maps.newConcurrentMap();
    private final Map<String, YopCredentials> yopCredentialsMap = Maps.newConcurrentMap();

    public final YopCredentials<?> getCredentials(String appKey, String credentialType) {
        String key = appKey + ":" + credentialType;
        return this.yopCredentialsMap.computeIfAbsent(key, k -> this.buildCredentials(this.getAppConfig(appKey), credentialType));
    }

    public List<CertTypeEnum> getSupportCertTypes(String appKey) {
        return Lists.newArrayList(this.getAppConfig(appKey).getIsvPrivateKeys().keySet());
    }

    private YopAppConfig getAppConfig(String appKey) {
        String appKeyHandled = this.useDefaultIfBlank(appKey);
        return this.appConfigs.computeIfAbsent(appKeyHandled, k -> this.loadAppConfig(appKeyHandled));
    }

    protected abstract YopAppConfig loadAppConfig(String var1);

    public List<YopCertConfig> getIsvEncryptKey(String appKey) {
        return this.getAppConfig(appKey).getIsvEncryptKey();
    }
}

