/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.security.encrypt;

import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopSymmetricCredentials;
import com.yeepay.yop.sdk.auth.credentials.provider.YopPlatformCredentialsProviderRegistry;
import com.yeepay.yop.sdk.base.security.encrypt.AbstractEncryptOptionsEnhancer;
import com.yeepay.yop.sdk.base.security.encrypt.YopEncryptorFactory;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptions;
import com.yeepay.yop.sdk.utils.Encodes;

public class Sm2Enhancer
extends AbstractEncryptOptionsEnhancer {
    private final String appKey;

    public Sm2Enhancer(String appKey) {
        this.appKey = appKey;
    }

    public EncryptOptions enhance(EncryptOptions source) {
        if (!this.checkForEnhance(source)) {
            return source;
        }
        YopSymmetricCredentials sourceCredentials = (YopSymmetricCredentials)source.getCredentials();
        String credentialStr = sourceCredentials.getCredential();
        byte[] credentialBytes = Encodes.decodeBase64(credentialStr);
        YopPlatformCredentials yopPlatformCredentials = YopPlatformCredentialsProviderRegistry.getProvider().getLatestCredentials(this.appKey, CertTypeEnum.SM2.getValue());
        source.setEncryptedCredentials(YopEncryptorFactory.getEncryptor("SM2").encryptToBase64(credentialBytes, new EncryptOptions((Object)yopPlatformCredentials)));
        source.setCredentialsAlg("SM2");
        source.setCredentials((Object)new YopSymmetricCredentials(this.appKey, credentialStr));
        source.enhance("YOP_SM2_CERT_SERIAL_NO", (Object)yopPlatformCredentials.getSerialNo());
        return source;
    }
}

