/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.security.encrypt;

import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptions;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptionsEnhancer;
import com.yeepay.yop.sdk.security.encrypt.YopEncryptor;
import com.yeepay.yop.sdk.utils.Encodes;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;

public abstract class YopEncryptorAdaptor
implements YopEncryptor {
    protected static final ThreadPoolExecutor THREAD_POOL = new ThreadPoolExecutor(2, 20, 3L, TimeUnit.MINUTES, Queues.newLinkedBlockingQueue((int)200), new ThreadFactoryBuilder().setNameFormat("yop-encryptor-task-%d").setDaemon(true).build(), new ThreadPoolExecutor.CallerRunsPolicy());

    public Future<EncryptOptions> initOptions(String encryptAlg, List<EncryptOptionsEnhancer> enhancers) {
        return THREAD_POOL.submit(new InitOptionsTask(encryptAlg, enhancers));
    }

    public String encryptToBase64(String plain, EncryptOptions options) {
        try {
            return Encodes.encodeUrlSafeBase64(this.encrypt(plain.getBytes("UTF-8"), options));
        }
        catch (UnsupportedEncodingException e) {
            throw new YopClientException("error happened when encrypt data", (Throwable)e);
        }
    }

    public String encryptToBase64(byte[] plain, EncryptOptions options) {
        return Encodes.encodeUrlSafeBase64(this.encrypt(plain, options));
    }

    public String decryptFromBase64(String cipher, EncryptOptions options) {
        return this.decryptToPlain(Encodes.decodeBase64(cipher), options);
    }

    public String decryptToPlain(byte[] cipher, EncryptOptions options) {
        try {
            return new String(this.decrypt(cipher, options), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new YopClientException("error happened when decrypt data", (Throwable)e);
        }
    }

    public abstract EncryptOptions doInitEncryptOptions(String var1) throws Exception;

    private class InitOptionsTask
    implements Callable<EncryptOptions> {
        private final String encryptAlg;
        private final List<EncryptOptionsEnhancer> enhancers;

        public InitOptionsTask(String encryptAlg, List<EncryptOptionsEnhancer> enhancers) {
            this.encryptAlg = encryptAlg;
            this.enhancers = enhancers;
        }

        @Override
        public EncryptOptions call() throws Exception {
            EncryptOptions inited = YopEncryptorAdaptor.this.doInitEncryptOptions(this.encryptAlg);
            if (CollectionUtils.isNotEmpty(this.enhancers)) {
                for (EncryptOptionsEnhancer enhancer : this.enhancers) {
                    inited = enhancer.enhance(inited);
                }
            }
            return inited;
        }
    }
}

