/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.client;

import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.auth.credentials.provider.YopCredentialsProvider;
import com.yeepay.yop.sdk.auth.req.AuthorizationReq;
import com.yeepay.yop.sdk.auth.req.AuthorizationReqRegistry;
import com.yeepay.yop.sdk.auth.req.AuthorizationReqSupport;
import com.yeepay.yop.sdk.base.auth.signer.YopSignerFactory;
import com.yeepay.yop.sdk.base.cache.EncryptOptionsCache;
import com.yeepay.yop.sdk.client.ClientExecutionParams;
import com.yeepay.yop.sdk.client.ClientHandler;
import com.yeepay.yop.sdk.client.ClientHandlerParams;
import com.yeepay.yop.sdk.client.router.GateWayRouter;
import com.yeepay.yop.sdk.client.router.ServerRootSpace;
import com.yeepay.yop.sdk.client.router.SimpleGateWayRouter;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.ExecutionContext;
import com.yeepay.yop.sdk.http.YopHttpClient;
import com.yeepay.yop.sdk.http.YopHttpClientFactory;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.internal.RequestAnalyzer;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.BaseResponse;
import com.yeepay.yop.sdk.model.YopRequestConfig;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptions;
import com.yeepay.yop.sdk.security.encrypt.YopEncryptor;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ClientHandlerImpl
implements ClientHandler {
    private final YopCredentialsProvider yopCredentialsProvider;
    private final AuthorizationReqRegistry authorizationReqRegistry;
    private final YopHttpClient client;
    private final GateWayRouter gateWayRouter;

    public ClientHandlerImpl(ClientHandlerParams handlerParams) {
        this.yopCredentialsProvider = handlerParams.getClientParams().getCredentialsProvider();
        this.authorizationReqRegistry = handlerParams.getClientParams().getAuthorizationReqRegistry();
        ServerRootSpace serverRootSpace = new ServerRootSpace(handlerParams.getClientParams().getEndPoint(), handlerParams.getClientParams().getYosEndPoint(), handlerParams.getClientParams().getSandboxEndPoint());
        this.gateWayRouter = new SimpleGateWayRouter(serverRootSpace);
        this.client = this.buildHttpClient(handlerParams);
    }

    private YopHttpClient buildHttpClient(ClientHandlerParams handlerParams) {
        YopHttpClient yopHttpClient = null == handlerParams ? YopHttpClientFactory.getDefaultClient() : YopHttpClientFactory.getClient(handlerParams.getClientParams().getClientConfiguration());
        return yopHttpClient;
    }

    @Override
    public <Input extends BaseRequest, Output extends BaseResponse> Output execute(ClientExecutionParams<Input, Output> executionParams) {
        Input input = executionParams.getInput();
        ExecutionContext executionContext = this.getExecutionContext(executionParams);
        Request<Input> request = executionParams.getRequestMarshaller().marshall(input);
        request.setEndpoint(this.gateWayRouter.route(executionContext.getYopCredentials().getAppKey(), request));
        return this.client.execute(request, ((BaseRequest)request.getOriginalRequestObject()).getRequestConfig(), executionContext, executionParams.getResponseHandler());
    }

    private <Output extends BaseResponse, Input extends BaseRequest> ExecutionContext getExecutionContext(ClientExecutionParams<Input, Output> executionParams) {
        AuthorizationReq authorizationReq = this.getAuthorizationReq(executionParams.getInput());
        if (authorizationReq == null) {
            throw new YopClientException("no authenticate req defined");
        }
        YopRequestConfig requestConfig = ((BaseRequest)executionParams.getInput()).getRequestConfig();
        YopCredentials<?> credential = RequestAnalyzer.getCredentials(requestConfig, authorizationReq);
        YopEncryptor encryptor = null;
        Future<EncryptOptions> encryptOptions = null;
        if (RequestAnalyzer.isEncryptSupported(credential, requestConfig)) {
            encryptor = RequestAnalyzer.getEncryptor(requestConfig);
            encryptOptions = EncryptOptionsCache.loadEncryptOptions(credential.getAppKey(), requestConfig.getEncryptAlg());
        }
        ExecutionContext.Builder builder = ExecutionContext.Builder.anExecutionContext().withYopCredentials(credential).withEncryptor(encryptor).withEncryptOptions(encryptOptions).withSigner(YopSignerFactory.getSigner(authorizationReq.getSignerType())).withSignOptions(authorizationReq.getSignOptions());
        return builder.build();
    }

    private <Input extends BaseRequest> AuthorizationReq getAuthorizationReq(Input input) {
        String customSecurityReq;
        String appKey = input.getRequestConfig().getAppKey();
        String string = customSecurityReq = input.getRequestConfig() == null ? null : input.getRequestConfig().getSecurityReq();
        if (StringUtils.isNotEmpty((CharSequence)customSecurityReq)) {
            return this.checkCustomSecurityReq(customSecurityReq);
        }
        List<CertTypeEnum> availableCerts = this.checkAvailableCerts(appKey);
        List<AuthorizationReq> authReqsForApi = this.checkAuthReqsByApi(input.getOperationId());
        return this.computeSecurityReq(availableCerts, authReqsForApi);
    }

    private AuthorizationReq computeSecurityReq(List<CertTypeEnum> availableCerts, List<AuthorizationReq> authReqsForApi) {
        for (AuthorizationReq authorizationReq : authReqsForApi) {
            if (!availableCerts.contains(CertTypeEnum.parse((String)authorizationReq.getCredentialType()))) continue;
            return authorizationReq;
        }
        throw new YopClientException("can not computeSecurityReq, please check your cert config");
    }

    private List<AuthorizationReq> checkAuthReqsByApi(String operationId) {
        List apiAuthReqs = this.authorizationReqRegistry.getAuthorizationReq(operationId);
        if (CollectionUtils.isEmpty((Collection)apiAuthReqs)) {
            return AuthorizationReqSupport.getDefaultAuthReqsForApi();
        }
        return apiAuthReqs;
    }

    private AuthorizationReq checkCustomSecurityReq(String customSecurityReq) {
        AuthorizationReq authorizationReq = AuthorizationReqSupport.getAuthorizationReq((String)customSecurityReq);
        if (authorizationReq == null) {
            throw new YopClientException("unsupported customSecurityReq:" + customSecurityReq);
        }
        return authorizationReq;
    }

    private List<CertTypeEnum> checkAvailableCerts(String appKey) {
        List configPrivateCerts = this.yopCredentialsProvider.getSupportCertTypes(appKey);
        if (CollectionUtils.isEmpty((Collection)configPrivateCerts)) {
            throw new YopClientException("can not find private key for appKey:" + appKey);
        }
        return configPrivateCerts;
    }

    @Override
    public void shutdown() {
        this.client.shutdown();
    }
}

