/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.http;

import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.YopHttpResponse;
import com.yeepay.yop.sdk.utils.DateUtils;
import com.yeepay.yop.sdk.utils.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractYopHttpResponse
implements YopHttpResponse {
    private static final Logger logger = LoggerFactory.getLogger(AbstractYopHttpResponse.class);
    private InputStream content;
    private String contentStr;
    private final Map<String, String> headers = Maps.newHashMap();
    private final Map<String, String> canonicalHeaders = Maps.newHashMap();

    @Override
    public String getHeader(String name) {
        return this.canonicalHeaders.get(StringUtils.lowerCase((String)name));
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public Map<String, String> getCanonicalHeaders() {
        return this.canonicalHeaders;
    }

    @Override
    public InputStream getContent() {
        return this.content;
    }

    @Override
    public String readContent() {
        if (this.contentStr != null) {
            return this.contentStr;
        }
        try {
            String string = this.contentStr = IOUtils.toString((InputStream)this.content, (String)"UTF-8");
            return string;
        }
        catch (IOException ex) {
            throw new YopClientException("unable to read response content", (Throwable)ex);
        }
        finally {
            StreamUtils.closeQuietly(this.content);
        }
    }

    @Override
    public void setContent(Object content) {
        if (content instanceof String) {
            this.contentStr = (String)content;
        } else {
            this.content = (InputStream)content;
        }
    }

    @Override
    public long getHeaderAsLong(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        try {
            return Long.valueOf(value);
        }
        catch (Exception e) {
            logger.warn("Invalid " + name + ":" + value, (Throwable)e);
            return -1L;
        }
    }

    @Override
    public Date getHeaderAsRfc822Date(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return null;
        }
        try {
            return DateUtils.parseRfc822Date(value);
        }
        catch (Exception e) {
            logger.warn("Invalid " + name + ":" + value, (Throwable)e);
            return null;
        }
    }

    protected void fillHeader(String name, String value) {
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            this.headers.put(name, value);
            this.canonicalHeaders.put(name.trim().toLowerCase(), value);
        }
    }
}

