/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.http.analyzer;

import com.yeepay.yop.sdk.auth.SignOptions;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentials;
import com.yeepay.yop.sdk.auth.credentials.provider.YopPlatformCredentialsProviderRegistry;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.HttpResponseAnalyzer;
import com.yeepay.yop.sdk.http.HttpResponseHandleContext;
import com.yeepay.yop.sdk.model.BaseResponse;
import com.yeepay.yop.sdk.model.YopResponseMetadata;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopSignatureCheckAnalyzer
implements HttpResponseAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopSignatureCheckAnalyzer.class);
    private static final YopSignatureCheckAnalyzer INSTANCE = new YopSignatureCheckAnalyzer();

    public static YopSignatureCheckAnalyzer getInstance() {
        return INSTANCE;
    }

    private YopSignatureCheckAnalyzer() {
    }

    @Override
    public <T extends BaseResponse> boolean analysis(HttpResponseHandleContext context, T response) throws Exception {
        SignOptions reqOptions;
        YopPlatformCredentials platformCredentials;
        YopResponseMetadata metadata = response.getMetadata();
        if (BooleanUtils.isTrue((Boolean)context.isSkipVerifySign()) || StringUtils.isBlank((CharSequence)metadata.getYopSign())) {
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("response sign verify begin, requestId:{}, sign:{}", (Object)metadata.getYopRequestId(), (Object)metadata.getYopSign());
        }
        if (null == (platformCredentials = this.getPlatformCredential(reqOptions = context.getSignOptions(), context.getAppKey(), metadata.getYopCertSerialNo()))) {
            throw new YopClientException("yop platform credentials not found");
        }
        context.getSigner().checkSignature(context.getResponse(), metadata.getYopSign(), (YopCredentials<?>)platformCredentials, new SignOptions().withDigestAlg(reqOptions.getDigestAlg()).withProtocolPrefix(reqOptions.getProtocolPrefix()).withExpirationInSeconds(reqOptions.getExpirationInSeconds()).withUrlSafe(!StringUtils.containsAny((CharSequence)metadata.getYopSign(), (char[])new char[]{'+', '/', '='})));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("response sign verify success, requestId:{}, sign:{}", (Object)metadata.getYopRequestId(), (Object)metadata.getYopSign());
        }
        return false;
    }

    private YopPlatformCredentials getPlatformCredential(SignOptions signOptions, String appKey, String serialNo) {
        CertTypeEnum certType;
        CertTypeEnum certTypeEnum = certType = "YOP-SM2-SM3".equals(signOptions.getProtocolPrefix()) ? CertTypeEnum.SM2 : CertTypeEnum.RSA2048;
        if (certType == CertTypeEnum.RSA2048) {
            if (StringUtils.isNotBlank((CharSequence)serialNo)) {
                LOGGER.warn("rsa signed request not need serialNo:{}.", (Object)serialNo);
            }
            serialNo = "rsa";
        }
        return YopPlatformCredentialsProviderRegistry.getProvider().getCredentials(appKey, serialNo);
    }
}

