/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.model.transform;

import com.google.common.collect.Lists;
import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.internal.RestartableInputStream;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.service.common.request.YopRequest;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;

public abstract class AbstractYopRequestMarshaller
implements RequestMarshaller<YopRequest> {
    @Override
    public Request<YopRequest> marshall(YopRequest request) {
        Request<YopRequest> internalRequest = this.initRequest(request);
        internalRequest.setResourcePath(request.getApiUri());
        internalRequest.setHttpMethod(HttpMethodName.valueOf(request.getHttpMethod().toUpperCase()));
        Map<String, String> customerHeaders = request.getHeaders();
        if (customerHeaders != null) {
            for (String string : customerHeaders.keySet()) {
                internalRequest.addHeader(string, customerHeaders.get(string));
            }
        }
        if (!request.getParameters().isEmpty()) {
            for (Map.Entry entry : request.getParameters().asMap().entrySet()) {
                internalRequest.addParameters((String)entry.getKey(), Lists.newArrayList((Iterable)((Iterable)entry.getValue())));
            }
        }
        if (!request.getMultipartFiles().isEmpty()) {
            for (Map.Entry entry : request.getMultipartFiles().asMap().entrySet()) {
                String name = (String)entry.getKey();
                for (Object value : (Collection)entry.getValue()) {
                    if (value instanceof File) {
                        internalRequest.addMultiPartFile(name, (File)value);
                        continue;
                    }
                    if (value instanceof InputStream) {
                        internalRequest.addMultiPartFile(name, (InputStream)value);
                        continue;
                    }
                    throw new YopClientException("Unexpected file parameter type, name:" + name + ", type:" + value.getClass() + ".");
                }
            }
            internalRequest.setContentType(YopContentType.MULTIPART_FORM);
        } else if (request.getContent() != null) {
            if (request.getContent() instanceof String) {
                byte[] contentBytes = ((String)request.getContent()).getBytes(YopConstants.DEFAULT_CHARSET);
                internalRequest.setContent(RestartableInputStream.wrap(contentBytes));
                internalRequest.addHeader("Content-Length", String.valueOf(contentBytes.length));
                internalRequest.setContentType(YopContentType.JSON);
            } else if (request.getContent() instanceof InputStream) {
                internalRequest.setContent((InputStream)request.getContent());
                internalRequest.setContentType(YopContentType.OCTET_STREAM);
            }
        } else {
            internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        }
        if (!YopContentType.MULTIPART_FORM.equals((Object)internalRequest.getContentType())) {
            internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        }
        return internalRequest;
    }

    protected abstract Request<YopRequest> initRequest(YopRequest var1);
}

