/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.common;

import com.yeepay.yop.sdk.client.ClientExecutionParams;
import com.yeepay.yop.sdk.client.ClientHandler;
import com.yeepay.yop.sdk.client.ClientHandlerImpl;
import com.yeepay.yop.sdk.client.ClientHandlerParams;
import com.yeepay.yop.sdk.client.ClientParams;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.HttpResponseAnalyzerSupport;
import com.yeepay.yop.sdk.http.handler.DefaultHttpResponseHandler;
import com.yeepay.yop.sdk.model.yos.YosDownloadResponse;
import com.yeepay.yop.sdk.service.common.YopClient;
import com.yeepay.yop.sdk.service.common.request.YopRequest;
import com.yeepay.yop.sdk.service.common.request.YopRequestMarshaller;
import com.yeepay.yop.sdk.service.common.response.YopResponse;
import com.yeepay.yop.sdk.service.common.response.YosUploadResponse;

public class YopClientImpl
implements YopClient {
    private final ClientHandler clientHandler;

    YopClientImpl(ClientParams clientParams) {
        this.clientHandler = new ClientHandlerImpl(new ClientHandlerParams().withClientParams(clientParams));
    }

    @Override
    public YopResponse request(YopRequest request) {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        YopRequestMarshaller requestMarshaller = YopRequestMarshaller.getInstance();
        DefaultHttpResponseHandler<YopResponse> responseHandler = new DefaultHttpResponseHandler<YopResponse>(YopResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return this.clientHandler.execute(new ClientExecutionParams().withInput(request).withRequestMarshaller(requestMarshaller).withResponseHandler(responseHandler));
    }

    @Override
    public YosDownloadResponse download(YopRequest request) {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        YopRequestMarshaller requestMarshaller = YopRequestMarshaller.getInstance();
        DefaultHttpResponseHandler<YosDownloadResponse> responseHandler = new DefaultHttpResponseHandler<YosDownloadResponse>(YosDownloadResponse.class, HttpResponseAnalyzerSupport.getYosDownloadAnalyzerChain());
        return this.clientHandler.execute(new ClientExecutionParams().withInput(request).withRequestMarshaller(requestMarshaller).withResponseHandler(responseHandler));
    }

    @Override
    public YosUploadResponse upload(YopRequest request) {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        if (request.getMultipartFiles().isEmpty() && request.getContent() == null) {
            throw new YopClientException("request.multiPartFiles and request.content both are empty.");
        }
        YopRequestMarshaller requestMarshaller = YopRequestMarshaller.getInstance();
        DefaultHttpResponseHandler<YosUploadResponse> responseHandler = new DefaultHttpResponseHandler<YosUploadResponse>(YosUploadResponse.class, HttpResponseAnalyzerSupport.getYosUploadAnalyzerChain());
        return this.clientHandler.execute(new ClientExecutionParams().withInput(request).withRequestMarshaller(requestMarshaller).withResponseHandler(responseHandler));
    }
}

