/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.utils;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.auth.credentials.CredentialsItem;
import com.yeepay.yop.sdk.auth.credentials.PKICredentialsItem;
import com.yeepay.yop.sdk.auth.credentials.YopPKICredentials;
import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentials;
import com.yeepay.yop.sdk.auth.credentials.YopSymmetricCredentials;
import com.yeepay.yop.sdk.auth.credentials.provider.YopCredentialsProviderRegistry;
import com.yeepay.yop.sdk.auth.credentials.provider.YopPlatformCredentialsProviderRegistry;
import com.yeepay.yop.sdk.auth.signer.process.YopSignProcessor;
import com.yeepay.yop.sdk.base.auth.signer.process.YopSignProcessorFactory;
import com.yeepay.yop.sdk.base.security.encrypt.YopEncryptorFactory;
import com.yeepay.yop.sdk.exception.VerifySignFailedException;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.security.DigestAlgEnum;
import com.yeepay.yop.sdk.security.SymmetricEncryptAlgEnum;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptions;
import com.yeepay.yop.sdk.security.encrypt.YopEncryptor;
import com.yeepay.yop.sdk.utils.Encodes;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DigitalEnvelopeUtils {
    private static final String SEPARATOR = "$";
    private static final Map<DigestAlgEnum, CertTypeEnum> CERT_TYPE_ENUM_MAP = Maps.newHashMap();
    private static final Map<String, String> ENCRYPTOR_MAP;
    private static final Map<DigestAlgEnum, String> SIGNER_MAP;

    public static String decrypt(String cipherText, PrivateKey privateKey) {
        return DigitalEnvelopeUtils.decrypt(cipherText, YopCredentialsProviderRegistry.getProvider().getDefaultAppKey(), privateKey);
    }

    public static String decrypt(String cipherText, String appKey, PrivateKey privateKey) {
        String[] args = cipherText.split("\\$");
        if (args.length != 4) {
            throw new RuntimeException("source invalid : " + cipherText);
        }
        String encryptedRandomKeyToBase64 = args[0];
        String encryptedDataToBase64 = args[1];
        SymmetricEncryptAlgEnum symmetricEncryptAlg = SymmetricEncryptAlgEnum.parse((String)args[2]);
        DigestAlgEnum digestAlg = DigestAlgEnum.valueOf((String)args[3]);
        CertTypeEnum certType = CERT_TYPE_ENUM_MAP.get(digestAlg);
        YopEncryptor unSymmetric = YopEncryptorFactory.getEncryptor(ENCRYPTOR_MAP.get(digestAlg.name()));
        byte[] randomKey = unSymmetric.decrypt(Encodes.decodeBase64(encryptedRandomKeyToBase64), new EncryptOptions((Object)new YopPKICredentials(appKey, new PKICredentialsItem(privateKey, certType))));
        String encryptAlg = ENCRYPTOR_MAP.get(symmetricEncryptAlg.name());
        YopEncryptor symmetric = YopEncryptorFactory.getEncryptor(encryptAlg);
        byte[] decryptedData = symmetric.decrypt(Encodes.decodeBase64(encryptedDataToBase64), new EncryptOptions((Object)new YopSymmetricCredentials(Encodes.encodeBase64(randomKey)), encryptAlg));
        String data = new String(decryptedData, Charsets.UTF_8);
        String sourceData = StringUtils.substringBeforeLast((String)data, (String)SEPARATOR);
        String signToBase64 = StringUtils.substringAfterLast((String)data, (String)SEPARATOR);
        YopPlatformCredentials platformCredentials = YopPlatformCredentialsProviderRegistry.getProvider().getLatestCredentials(appKey, certType.getValue());
        YopSignProcessor yopSignProcess = YopSignProcessorFactory.getSignProcessor(SIGNER_MAP.get(digestAlg));
        boolean verifySign = yopSignProcess.verify(sourceData, signToBase64, (CredentialsItem)platformCredentials.getCredential());
        if (!verifySign) {
            throw new YopClientException("verifySign fail!");
        }
        return sourceData;
    }

    public static String decrypt(String cipherText, String credentialType) {
        return DigitalEnvelopeUtils.decrypt(cipherText, YopCredentialsProviderRegistry.getProvider().getDefaultAppKey(), credentialType);
    }

    public static String decrypt(String cipherText, String appKey, String credentialType) {
        YopPKICredentials yopCredentials = (YopPKICredentials)YopCredentialsProviderRegistry.getProvider().getCredentials(appKey, credentialType);
        PKICredentialsItem pkiCredentialsItem = yopCredentials.getCredential();
        return DigitalEnvelopeUtils.decrypt(cipherText, appKey, pkiCredentialsItem.getPrivateKey());
    }

    public static void verify(String content, String signature, PublicKey publicKey) {
        String[] args = signature.split("\\$");
        if (args.length != 2) {
            throw new VerifySignFailedException("Illegal format");
        }
        String signToBase64 = args[0];
        boolean verifySign = YopSignProcessorFactory.getSignProcessor(CertTypeEnum.RSA2048.getValue()).verify(content.replaceAll("[ \t\n]", ""), signToBase64, (CredentialsItem)new PKICredentialsItem(publicKey, CertTypeEnum.RSA2048));
        if (!verifySign) {
            throw new VerifySignFailedException("Unexpected signature");
        }
    }

    static {
        CERT_TYPE_ENUM_MAP.put(DigestAlgEnum.SM3, CertTypeEnum.SM2);
        CERT_TYPE_ENUM_MAP.put(DigestAlgEnum.SHA256, CertTypeEnum.RSA2048);
        ENCRYPTOR_MAP = Maps.newHashMap();
        ENCRYPTOR_MAP.put(DigestAlgEnum.SHA256.name(), "RSA");
        ENCRYPTOR_MAP.put(DigestAlgEnum.SM3.name(), "SM2");
        ENCRYPTOR_MAP.put(SymmetricEncryptAlgEnum.AES.name(), "AES");
        ENCRYPTOR_MAP.put(SymmetricEncryptAlgEnum.SM4.name(), "SM4/CBC/PKCS5Padding");
        SIGNER_MAP = Maps.newHashMap();
        SIGNER_MAP.put(DigestAlgEnum.SHA256, "RSA2048");
        SIGNER_MAP.put(DigestAlgEnum.SM3, "SM2");
    }
}

