/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.xml;

import de.schlichtherle.xml.PersistenceServiceException;
import de.schlichtherle.xml.XMLConstants;
import java.beans.Encoder;
import java.beans.ExceptionListener;
import java.beans.PersistenceDelegate;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PersistenceService
implements XMLConstants {
    private static final HashMap allPDs = new HashMap();
    public static int BUFSIZE = 8192;

    private PersistenceService() {
    }

    private static final ExceptionListener createExceptionListener() {
        return new ExceptionListener(){

            public void exceptionThrown(Exception exception) {
                throw exception instanceof UndeclaredThrowableException ? (UndeclaredThrowableException)exception : new UndeclaredThrowableException(exception);
            }
        };
    }

    public static final synchronized void setPersistenceDelegate(Class clazz, PersistenceDelegate persistenceDelegate) {
        allPDs.put(clazz, persistenceDelegate);
    }

    protected static synchronized void installPersistenceDelegates(Encoder encoder) {
        Iterator iterator = allPDs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            encoder.setPersistenceDelegate((Class)entry.getKey(), (PersistenceDelegate)entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(Object object, OutputStream outputStream) throws PersistenceServiceException {
        if (outputStream == null) {
            throw new NullPointerException();
        }
        try {
            BufferedOutputStream bufferedOutputStream = null;
            XMLEncoder xMLEncoder = null;
            try {
                bufferedOutputStream = new BufferedOutputStream(outputStream, BUFSIZE);
                xMLEncoder = new XMLEncoder(bufferedOutputStream);
                PersistenceService.installPersistenceDelegates(xMLEncoder);
                xMLEncoder.setExceptionListener(PersistenceService.createExceptionListener());
                xMLEncoder.writeObject(object);
            }
            finally {
                if (xMLEncoder != null) {
                    try {
                        xMLEncoder.close();
                    }
                    catch (Throwable throwable) {
                        ((OutputStream)bufferedOutputStream).close();
                        throw throwable;
                    }
                } else if (bufferedOutputStream != null) {
                    ((OutputStream)bufferedOutputStream).close();
                } else {
                    outputStream.close();
                }
            }
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            throw new PersistenceServiceException(undeclaredThrowableException.getCause());
        }
        catch (Throwable throwable) {
            throw new PersistenceServiceException(throwable);
        }
    }

    public static void store(Object object, File file) throws PersistenceServiceException {
        if (file == null) {
            throw new NullPointerException();
        }
        File file2 = null;
        boolean bl = false;
        try {
            file2 = PersistenceService.getRenamedFile(file);
            bl = file.renameTo(file2);
            PersistenceService.store(object, new FileOutputStream(file));
            if (bl) {
                file2.delete();
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            if (bl) {
                try {
                    file.delete();
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                }
                try {
                    file2.renameTo(file);
                }
                catch (Throwable throwable4) {
                    throwable2 = throwable4;
                }
            }
            throw throwable2 instanceof PersistenceServiceException ? (PersistenceServiceException)throwable2 : new PersistenceServiceException(throwable2);
        }
    }

    private static File getRenamedFile(File file) {
        File file2;
        StringBuilder stringBuilder = new StringBuilder(file.getPath());
        while ((file2 = new File(stringBuilder.append('~').toString())).exists()) {
        }
        return file2;
    }

    public static byte[] store2ByteArray(Object object) throws PersistenceServiceException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PersistenceService.store(object, byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (PersistenceServiceException persistenceServiceException) {
            throw persistenceServiceException;
        }
        catch (Throwable throwable) {
            throw new PersistenceServiceException(throwable);
        }
    }

    public static String store2String(Object object) throws PersistenceServiceException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PersistenceService.store(object, byteArrayOutputStream);
            return byteArrayOutputStream.toString("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
        catch (PersistenceServiceException persistenceServiceException) {
            throw persistenceServiceException;
        }
        catch (Throwable throwable) {
            throw new PersistenceServiceException(throwable);
        }
    }

    public static Object load(InputStream inputStream) throws PersistenceServiceException {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        XMLDecoder xMLDecoder = null;
        try {
            xMLDecoder = new XMLDecoder(new BufferedInputStream(inputStream, BUFSIZE), null, PersistenceService.createExceptionListener());
            Object object = xMLDecoder.readObject();
            return object;
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            throw new PersistenceServiceException(undeclaredThrowableException.getCause());
        }
        catch (Throwable throwable) {
            throw new PersistenceServiceException(throwable);
        }
        finally {
            if (xMLDecoder != null) {
                try {
                    xMLDecoder.close();
                }
                catch (Throwable throwable) {
                    throw new PersistenceServiceException(throwable);
                }
            }
        }
    }

    public static Object load(File file) throws PersistenceServiceException {
        if (file == null) {
            throw new NullPointerException();
        }
        try {
            return PersistenceService.load(new FileInputStream(file));
        }
        catch (PersistenceServiceException persistenceServiceException) {
            throw persistenceServiceException;
        }
        catch (Throwable throwable) {
            throw new PersistenceServiceException(throwable);
        }
    }

    public static Object load(byte[] byArray) throws PersistenceServiceException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        try {
            return PersistenceService.load(new ByteArrayInputStream(byArray));
        }
        catch (PersistenceServiceException persistenceServiceException) {
            throw persistenceServiceException;
        }
        catch (Throwable throwable) {
            throw new PersistenceServiceException(throwable);
        }
    }

    public static Object load(String string) throws PersistenceServiceException {
        if (string == null) {
            throw new NullPointerException();
        }
        try {
            return PersistenceService.load(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
        catch (PersistenceServiceException persistenceServiceException) {
            throw persistenceServiceException;
        }
        catch (Throwable throwable) {
            throw new PersistenceServiceException(throwable);
        }
    }
}

