/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai;

import dev.ai4j.openai4j.OpenAiClient;
import dev.ai4j.openai4j.embedding.EmbeddingRequest;
import dev.ai4j.openai4j.embedding.EmbeddingResponse;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.embedding.DimensionAwareEmbeddingModel;
import dev.langchain4j.model.embedding.TokenCountEstimator;
import dev.langchain4j.model.openai.InternalOpenAiHelper;
import dev.langchain4j.model.openai.OpenAiEmbeddingModelName;
import dev.langchain4j.model.openai.OpenAiTokenizer;
import dev.langchain4j.model.openai.spi.OpenAiEmbeddingModelBuilderFactory;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.spi.ServiceHelper;
import java.net.Proxy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class OpenAiEmbeddingModel
extends DimensionAwareEmbeddingModel
implements TokenCountEstimator {
    private final OpenAiClient client;
    private final String modelName;
    private final Integer dimensions;
    private final String user;
    private final Integer maxRetries;
    private final Integer maxSegmentsPerBatch;
    private final Tokenizer tokenizer;

    public OpenAiEmbeddingModel(String baseUrl, String apiKey, String organizationId, String modelName, Integer dimensions, String user, Duration timeout, Integer maxRetries, Integer maxSegmentsPerBatch, Proxy proxy, Boolean logRequests, Boolean logResponses, Tokenizer tokenizer, Map<String, String> customHeaders) {
        baseUrl = (String)Utils.getOrDefault((Object)baseUrl, (Object)"https://api.openai.com/v1");
        if ("demo".equals(apiKey)) {
            baseUrl = "http://langchain4j.dev/demo/openai/v1";
        }
        timeout = (Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L));
        this.client = OpenAiClient.builder().openAiApiKey(apiKey).baseUrl(baseUrl).organizationId(organizationId).callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).proxy(proxy).logRequests(logRequests).logResponses(logResponses).userAgent("langchain4j-openai").customHeaders(customHeaders).build();
        this.modelName = (String)Utils.getOrDefault((Object)modelName, (Object)"text-embedding-ada-002");
        this.dimensions = dimensions;
        this.user = user;
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
        this.maxSegmentsPerBatch = (Integer)Utils.getOrDefault((Object)maxSegmentsPerBatch, (Object)2048);
        ValidationUtils.ensureGreaterThanZero((Integer)this.maxSegmentsPerBatch, (String)"maxSegmentsPerBatch");
        this.tokenizer = (Tokenizer)Utils.getOrDefault((Object)tokenizer, OpenAiTokenizer::new);
    }

    protected Integer knownDimension() {
        if (this.dimensions != null) {
            return this.dimensions;
        }
        return OpenAiEmbeddingModelName.knownDimension(this.modelName());
    }

    public String modelName() {
        return this.modelName;
    }

    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
        List<String> texts = textSegments.stream().map(TextSegment::text).toList();
        List<List<String>> textBatches = this.partition(texts, this.maxSegmentsPerBatch);
        return this.embedBatchedTexts(textBatches);
    }

    private List<List<String>> partition(List<String> inputList, int size) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        for (int i = 0; i < inputList.size(); i += size) {
            int fromIndex = i;
            int toIndex = Math.min(i + size, inputList.size());
            result.add(inputList.subList(fromIndex, toIndex));
        }
        return result;
    }

    private Response<List<Embedding>> embedBatchedTexts(List<List<String>> textBatches) {
        ArrayList<Response<List<Embedding>>> responses = new ArrayList<Response<List<Embedding>>>();
        for (List<String> batch : textBatches) {
            Response<List<Embedding>> response2 = this.embedTexts(batch);
            responses.add(response2);
        }
        return Response.from(responses.stream().flatMap(response -> ((List)response.content()).stream()).toList(), (TokenUsage)responses.stream().map(Response::tokenUsage).reduce(TokenUsage::add).orElse(null));
    }

    private Response<List<Embedding>> embedTexts(List<String> texts) {
        EmbeddingRequest request = EmbeddingRequest.builder().input(texts).model(this.modelName).dimensions(this.dimensions).user(this.user).build();
        EmbeddingResponse response = (EmbeddingResponse)RetryUtils.withRetry(() -> (EmbeddingResponse)this.client.embedding(request).execute(), (int)this.maxRetries);
        List<Embedding> embeddings = response.data().stream().map(openAiEmbedding -> Embedding.from((List)openAiEmbedding.embedding())).toList();
        return Response.from(embeddings, (TokenUsage)InternalOpenAiHelper.tokenUsageFrom(response.usage()));
    }

    public int estimateTokenCount(String text) {
        return this.tokenizer.estimateTokenCountInText(text);
    }

    @Deprecated(forRemoval=true)
    public static OpenAiEmbeddingModel withApiKey(String apiKey) {
        return OpenAiEmbeddingModel.builder().apiKey(apiKey).build();
    }

    public static OpenAiEmbeddingModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(OpenAiEmbeddingModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            OpenAiEmbeddingModelBuilderFactory factory = (OpenAiEmbeddingModelBuilderFactory)iterator.next();
            return (OpenAiEmbeddingModelBuilder)factory.get();
        }
        return new OpenAiEmbeddingModelBuilder();
    }

    public static class OpenAiEmbeddingModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String organizationId;
        private String modelName;
        private Integer dimensions;
        private String user;
        private Duration timeout;
        private Integer maxRetries;
        private Integer maxSegmentsPerBatch;
        private Proxy proxy;
        private Boolean logRequests;
        private Boolean logResponses;
        private Tokenizer tokenizer;
        private Map<String, String> customHeaders;

        public OpenAiEmbeddingModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public OpenAiEmbeddingModelBuilder modelName(OpenAiEmbeddingModelName modelName) {
            this.modelName = modelName.toString();
            return this;
        }

        public OpenAiEmbeddingModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public OpenAiEmbeddingModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public OpenAiEmbeddingModelBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public OpenAiEmbeddingModelBuilder dimensions(Integer dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public OpenAiEmbeddingModelBuilder user(String user) {
            this.user = user;
            return this;
        }

        public OpenAiEmbeddingModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public OpenAiEmbeddingModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public OpenAiEmbeddingModelBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public OpenAiEmbeddingModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public OpenAiEmbeddingModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public OpenAiEmbeddingModelBuilder tokenizer(Tokenizer tokenizer) {
            this.tokenizer = tokenizer;
            return this;
        }

        public OpenAiEmbeddingModelBuilder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public OpenAiEmbeddingModelBuilder maxSegmentsPerBatch(Integer maxSegmentsPerBatch) {
            this.maxSegmentsPerBatch = maxSegmentsPerBatch;
            return this;
        }

        public OpenAiEmbeddingModel build() {
            return new OpenAiEmbeddingModel(this.baseUrl, this.apiKey, this.organizationId, this.modelName, this.dimensions, this.user, this.timeout, this.maxRetries, this.maxSegmentsPerBatch, this.proxy, this.logRequests, this.logResponses, this.tokenizer, this.customHeaders);
        }

        public String toString() {
            return new StringJoiner(", ", OpenAiEmbeddingModelBuilder.class.getSimpleName() + "[", "]").add("baseUrl='" + this.baseUrl + "'").add("organizationId='" + this.organizationId + "'").add("modelName='" + this.modelName + "'").add("dimensions=" + this.dimensions).add("user='" + this.user + "'").add("timeout=" + String.valueOf(this.timeout)).add("maxRetries=" + this.maxRetries).add("proxy=" + String.valueOf(this.proxy)).add("logRequests=" + this.logRequests).add("logResponses=" + this.logResponses).add("tokenizer=" + String.valueOf(this.tokenizer)).add("customHeaders=" + String.valueOf(this.customHeaders)).toString();
        }
    }
}

