/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.commons.management;

import dk.dma.commons.management.DefaultManagedAttribute;
import dk.dma.commons.management.DefaultManagedOperation;
import dk.dma.commons.management.Managements;
import dk.dma.commons.management.OperationKey;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;

class DefaultMBean
implements DynamicMBean {
    private final Map<String, DefaultManagedAttribute> attributes;
    private final String description;
    private final String name;
    private final Map<OperationKey, DefaultManagedOperation> ops;

    DefaultMBean(String name, String description, Map<String, DefaultManagedAttribute> attributes, Map<OperationKey, DefaultManagedOperation> ops) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.description = Objects.requireNonNull(description, "description is null");
        this.attributes = Objects.requireNonNull(attributes, "attributes is null");
        this.ops = Objects.requireNonNull(ops, "ops is null");
    }

    private DefaultManagedAttribute findAttribute(String attribute) throws AttributeNotFoundException {
        DefaultManagedAttribute att = this.attributes.get(attribute);
        if (att == null) {
            throw new AttributeNotFoundException("Attribute " + attribute + " could not be found");
        }
        return att;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, ReflectionException {
        return this.findAttribute(attribute).getValue();
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList result = new AttributeList(attributes.length);
        for (String attrName : attributes) {
            try {
                Object attrValue = this.getAttribute(attrName);
                result.add(new Attribute(attrName, attrValue));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        ArrayList<MBeanAttributeInfo> infos = new ArrayList<MBeanAttributeInfo>();
        for (DefaultManagedAttribute aa : this.attributes.values()) {
            try {
                infos.add(aa.getInfo());
            }
            catch (javax.management.IntrospectionException e) {
                throw new IllegalStateException(e);
            }
        }
        ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
        for (DefaultManagedOperation op : this.ops.values()) {
            operations.add(op.getInfo());
        }
        return new MBeanInfo(this.name, this.description, infos.toArray(new MBeanAttributeInfo[0]), null, operations.toArray(new MBeanOperationInfo[0]), null);
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws ReflectionException {
        DefaultManagedOperation o = this.ops.get(new OperationKey(actionName, signature == null ? new String[]{} : signature));
        if (o == null) {
            throw new IllegalArgumentException("Unknown method " + actionName + " [ signature = " + Arrays.toString(signature) + "]");
        }
        return o.invoke(params);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, ReflectionException {
        this.findAttribute(attribute.getName()).setValue(attribute.getValue());
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList result = new AttributeList(attributes.size());
        for (Attribute attr : attributes.asList()) {
            try {
                this.setAttribute(attr);
                result.add(new Attribute(attr.getName(), attr.getValue()));
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static DefaultMBean createFrom(Object o, String name) {
        BeanInfo bi;
        Class<?> c = o.getClass();
        try {
            bi = Introspector.getBeanInfo(c);
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(e);
        }
        return new DefaultMBean(name, Managements.getDescription(c), DefaultManagedAttribute.fromPropertyDescriptors(bi.getPropertyDescriptors(), o), DefaultManagedOperation.getOperationFromMethods(o, c.getMethods()));
    }
}

