/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.commons.management;

import dk.dma.commons.management.ManagedAttribute;
import dk.dma.commons.management.Managements;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.ReflectionException;

class DefaultManagedAttribute {
    private final String description;
    private final String name;
    private final Method getter;
    private final Object obj;
    private final Method setter;

    DefaultManagedAttribute(Object obj, Method reader, Method writer, String name, String description) {
        if (reader == null && writer == null) {
            throw new NullPointerException("reader and writer cannot both be null");
        }
        this.name = Objects.requireNonNull(name, "name is null");
        this.description = Objects.requireNonNull(description, "description is null");
        this.obj = Objects.requireNonNull(obj, "obj is null");
        this.getter = reader;
        this.setter = writer;
    }

    MBeanAttributeInfo getInfo() throws IntrospectionException {
        return new MBeanAttributeInfo(this.name, this.description, this.getter, this.setter);
    }

    Object getValue() throws ReflectionException {
        if (this.getter == null) {
            throw new IllegalStateException("Attribute is write-only");
        }
        return Managements.invoke(this.getter, this.obj, "getter for the attribute " + this.name, null);
    }

    void setValue(Object o) throws ReflectionException {
        if (this.setter == null) {
            throw new IllegalStateException("Attribute is read-only");
        }
        Managements.invoke(this.setter, this.obj, "setter for the attribute " + this.name, o);
    }

    static DefaultManagedAttribute fromPropertyDescriptor(PropertyDescriptor pd, Object obj) {
        ManagedAttribute readAttribute = pd.getReadMethod() == null ? null : pd.getReadMethod().getAnnotation(ManagedAttribute.class);
        ManagedAttribute writeAttribute = pd.getWriteMethod() == null ? null : pd.getWriteMethod().getAnnotation(ManagedAttribute.class);
        Method writer = null;
        Method reader = null;
        if (readAttribute != null) {
            if (writeAttribute != null) {
                throw new IllegalArgumentException("cannot define ManagedAttribute on both setter and getter for " + pd.getReadMethod());
            }
            if (readAttribute.isWriteOnly()) {
                throw new IllegalArgumentException("cannot set writeonly on getter " + pd.getReadMethod());
            }
            reader = pd.getReadMethod();
            writeAttribute = readAttribute;
        } else if (writeAttribute != null) {
            writer = pd.getWriteMethod();
            if (!writeAttribute.isWriteOnly()) {
                reader = pd.getReadMethod();
            }
        } else {
            return null;
        }
        String name = Managements.filterString(obj, writeAttribute.name());
        if (name.equals("")) {
            name = DefaultManagedAttribute.capitalizeFirstLetter(pd.getName());
        }
        return new DefaultManagedAttribute(obj, reader, writer, name, Managements.getDescription(writer == null ? reader : writer));
    }

    public static Map<String, DefaultManagedAttribute> fromPropertyDescriptors(PropertyDescriptor[] pds, Object obj) {
        HashMap<String, DefaultManagedAttribute> result = new HashMap<String, DefaultManagedAttribute>();
        for (PropertyDescriptor pd : pds) {
            DefaultManagedAttribute a = DefaultManagedAttribute.fromPropertyDescriptor(pd, obj);
            if (a == null) continue;
            result.put(a.name, a);
        }
        return result;
    }

    static String capitalizeFirstLetter(String str) {
        if (str.length() > 0) {
            return DefaultManagedAttribute.replaceCharAt(str, 0, Character.toUpperCase(str.charAt(0)));
        }
        return str;
    }

    static String replaceCharAt(String s, int pos, char c) {
        return s.substring(0, pos) + c + s.substring(pos + 1);
    }
}

