/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.commons.management;

import dk.dma.commons.management.ManagedOperation;
import dk.dma.commons.management.Managements;
import dk.dma.commons.management.OperationKey;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;

class DefaultManagedOperation {
    private final String description;
    private final Method m;
    private final String name;
    private final Object o;
    private final int impact;

    DefaultManagedOperation(Object obj, Method method, String name, String description, int impact) {
        this.m = Objects.requireNonNull(method, "method is null");
        this.o = Objects.requireNonNull(obj, "object is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.description = Objects.requireNonNull(description, "description is null");
        this.impact = impact;
    }

    MBeanOperationInfo getInfo() {
        return new MBeanOperationInfo(this.name, this.description, Managements.methodSignature(this.m), this.m.getReturnType().getName(), this.impact);
    }

    Object invoke(Object ... arguments) throws ReflectionException {
        return Managements.invoke(this.m, this.o, "operation " + this.name, arguments);
    }

    public static Map<OperationKey, DefaultManagedOperation> getOperationFromMethods(Object obj, Method[] methods) {
        HashMap<OperationKey, DefaultManagedOperation> result = new HashMap<OperationKey, DefaultManagedOperation>();
        for (Method m : methods) {
            ManagedOperation mo = m.getAnnotation(ManagedOperation.class);
            if (mo == null) continue;
            String name = Managements.filterString(obj, mo.name());
            if (name.equals("")) {
                name = m.getName();
            }
            ArrayList<String> signatures = new ArrayList<String>();
            for (Class<?> c : m.getParameterTypes()) {
                signatures.add(c.getName());
            }
            result.put(new OperationKey(name, signatures.toArray(new String[0])), new DefaultManagedOperation(obj, m, name, Managements.getDescription(m), mo.impact()));
        }
        return result;
    }
}

