/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.asyncapi.models;

import io.apicurio.datamodels.asyncapi.models.AaiChannelBindingsDefinition;
import io.apicurio.datamodels.asyncapi.models.AaiCorrelationId;
import io.apicurio.datamodels.asyncapi.models.AaiMessage;
import io.apicurio.datamodels.asyncapi.models.AaiMessageBindingsDefinition;
import io.apicurio.datamodels.asyncapi.models.AaiMessageTraitDefinition;
import io.apicurio.datamodels.asyncapi.models.AaiOperationBindingsDefinition;
import io.apicurio.datamodels.asyncapi.models.AaiOperationTraitDefinition;
import io.apicurio.datamodels.asyncapi.models.AaiParameter;
import io.apicurio.datamodels.asyncapi.models.AaiSchema;
import io.apicurio.datamodels.asyncapi.models.AaiSecurityScheme;
import io.apicurio.datamodels.asyncapi.models.AaiServerBindingsDefinition;
import io.apicurio.datamodels.asyncapi.visitors.IAaiVisitor;
import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.common.Components;
import io.apicurio.datamodels.core.visitors.IVisitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AaiComponents
extends Components {
    public Map<String, AaiSchema> schemas;
    public Map<String, AaiMessage> messages;
    public Map<String, AaiSecurityScheme> securitySchemes;
    public Map<String, AaiParameter> parameters;
    public Map<String, AaiCorrelationId> correlationIds;
    public Map<String, AaiOperationTraitDefinition> operationTraits;
    public Map<String, AaiMessageTraitDefinition> messageTraits;
    public Map<String, AaiServerBindingsDefinition> serverBindings;
    public Map<String, AaiChannelBindingsDefinition> channelBindings;
    public Map<String, AaiOperationBindingsDefinition> operationBindings;
    public Map<String, AaiMessageBindingsDefinition> messageBindings;

    public AaiComponents() {
    }

    public AaiComponents(Node parent) {
        if (parent != null) {
            this._parent = parent;
            this._ownerDocument = parent.ownerDocument();
        }
    }

    @Override
    public void accept(IVisitor visitor) {
        IAaiVisitor v = (IAaiVisitor)visitor;
        v.visitComponents(this);
    }

    public List<AaiMessage> getMessagesList() {
        return JsonCompat.mapToList(this.messages);
    }

    public List<AaiSecurityScheme> getSecuritySchemesList() {
        return JsonCompat.mapToList(this.securitySchemes);
    }

    public List<AaiParameter> getParametersList() {
        return JsonCompat.mapToList(this.parameters);
    }

    public List<AaiCorrelationId> getCorrelationIdsList() {
        return JsonCompat.mapToList(this.correlationIds);
    }

    public List<AaiOperationTraitDefinition> getOperationTraitDefinitionsList() {
        return JsonCompat.mapToList(this.operationTraits);
    }

    public List<AaiMessageTraitDefinition> getMessageTraitDefinitionsList() {
        return JsonCompat.mapToList(this.messageTraits);
    }

    public List<AaiServerBindingsDefinition> getServerBindingsDefinitionList() {
        return JsonCompat.mapToList(this.serverBindings);
    }

    public List<AaiChannelBindingsDefinition> getChannelBindingsDefinitionList() {
        return JsonCompat.mapToList(this.channelBindings);
    }

    public List<AaiOperationBindingsDefinition> getOperationBindingsDefinitionList() {
        return JsonCompat.mapToList(this.operationBindings);
    }

    public List<AaiMessageBindingsDefinition> getMessageBindingsDefinitionList() {
        return JsonCompat.mapToList(this.messageBindings);
    }

    public void addSchemaDefinition(String key, AaiSchema value) {
        if (this.schemas == null) {
            this.schemas = new LinkedHashMap<String, AaiSchema>();
        }
        this.schemas.put(key, value);
    }

    public AaiSchema getSchemaDefinition(String name) {
        return this.schemas.get(name);
    }

    public AaiSchema removeSchemaDefinition(String name) {
        return this.schemas.remove(name);
    }

    public List<AaiSchema> getSchemaDefinitions() {
        ArrayList<AaiSchema> rval = new ArrayList<AaiSchema>();
        if (this.schemas != null) {
            rval.addAll(this.schemas.values());
        }
        return rval;
    }

    public void addMessage(String key, AaiMessage value) {
        if (this.messages == null) {
            this.messages = new LinkedHashMap<String, AaiMessage>();
        }
        this.messages.put(key, value);
    }

    public void addSecurityScheme(String key, AaiSecurityScheme value) {
        if (this.securitySchemes == null) {
            this.securitySchemes = new LinkedHashMap<String, AaiSecurityScheme>();
        }
        this.securitySchemes.put(key, value);
    }

    public void addParameter(String key, AaiParameter value) {
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, AaiParameter>();
        }
        this.parameters.put(key, value);
    }

    public void addCorrelationId(String key, AaiCorrelationId value) {
        if (this.correlationIds == null) {
            this.correlationIds = new LinkedHashMap<String, AaiCorrelationId>();
        }
        this.correlationIds.put(key, value);
    }

    public void addMessageTraitDefinition(String key, AaiMessageTraitDefinition value) {
        if (this.messageTraits == null) {
            this.messageTraits = new LinkedHashMap<String, AaiMessageTraitDefinition>();
        }
        this.messageTraits.put(key, value);
    }

    public void addOperationTraitDefinition(String key, AaiOperationTraitDefinition value) {
        if (this.operationTraits == null) {
            this.operationTraits = new LinkedHashMap<String, AaiOperationTraitDefinition>();
        }
        this.operationTraits.put(key, value);
    }

    public void addServerBindingDefinition(String key, AaiServerBindingsDefinition value) {
        if (this.serverBindings == null) {
            this.serverBindings = new LinkedHashMap<String, AaiServerBindingsDefinition>();
        }
        this.serverBindings.put(key, value);
    }

    public void addChannelBindingDefinition(String key, AaiChannelBindingsDefinition value) {
        if (this.channelBindings == null) {
            this.channelBindings = new LinkedHashMap<String, AaiChannelBindingsDefinition>();
        }
        this.channelBindings.put(key, value);
    }

    public void addOperationBindingDefinition(String key, AaiOperationBindingsDefinition value) {
        if (this.operationBindings == null) {
            this.operationBindings = new LinkedHashMap<String, AaiOperationBindingsDefinition>();
        }
        this.operationBindings.put(key, value);
    }

    public void addMessageBindingDefinition(String key, AaiMessageBindingsDefinition value) {
        if (this.messageBindings == null) {
            this.messageBindings = new LinkedHashMap<String, AaiMessageBindingsDefinition>();
        }
        this.messageBindings.put(key, value);
    }
}

