/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.DocumentType;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;
import java.util.List;

public abstract class AbstractSchemaInhCommand
extends AbstractCommand {
    public static final String TYPE_NONE = "none";
    public static final String TYPE_ALL_OF = "allOf";
    public static final String TYPE_ONE_OF = "oneOf";
    public static final String TYPE_ANY_OF = "anyOf";

    static String getInheritanceType(OasSchema schema) {
        if (ModelUtils.isDefined(schema.allOf)) {
            return TYPE_ALL_OF;
        }
        if (schema.ownerDocument().getDocumentType() == DocumentType.openapi3) {
            Oas30Schema schema30 = (Oas30Schema)schema;
            if (ModelUtils.isDefined(schema30.anyOf)) {
                return TYPE_ANY_OF;
            }
            if (ModelUtils.isDefined(schema30.oneOf)) {
                return TYPE_ONE_OF;
            }
        }
        return TYPE_NONE;
    }

    protected OasSchema createSchema(OasSchema parentSchema, String inheritanceType) {
        if (NodeCompat.equals(TYPE_ALL_OF, inheritanceType)) {
            return parentSchema.createAllOfSchema();
        }
        if (NodeCompat.equals(TYPE_ANY_OF, inheritanceType)) {
            Oas30Schema schema30 = (Oas30Schema)parentSchema;
            return schema30.createAnyOfSchema();
        }
        if (NodeCompat.equals(TYPE_ONE_OF, inheritanceType)) {
            Oas30Schema schema30 = (Oas30Schema)parentSchema;
            return schema30.createOneOfSchema();
        }
        return parentSchema.createAllOfSchema();
    }

    protected void copySchemaJsTo(List<Object> schemas, OasSchema targetSchema, String inheritanceType) {
        Oas30Schema targetSchema30;
        if (NodeCompat.equals(TYPE_ALL_OF, inheritanceType)) {
            schemas.forEach(ser -> targetSchema.addAllOfSchema((OasSchema)Library.readNode(ser, targetSchema.createAllOfSchema())));
        }
        if (NodeCompat.equals(TYPE_ANY_OF, inheritanceType)) {
            targetSchema30 = (Oas30Schema)targetSchema;
            schemas.forEach(ser -> targetSchema30.addAnyOfSchema((Oas30Schema.Oas30AnyOfSchema)Library.readNode(ser, targetSchema30.createAnyOfSchema())));
        }
        if (NodeCompat.equals(TYPE_ONE_OF, inheritanceType)) {
            targetSchema30 = (Oas30Schema)targetSchema;
            schemas.forEach(ser -> targetSchema30.addOneOfSchema((Oas30Schema.Oas30OneOfSchema)Library.readNode(ser, targetSchema30.createOneOfSchema())));
        }
    }
}

