/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.commands.AddSchemaDefinitionCommand;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20SchemaDefinition;

public class AddSchemaDefinitionCommand_20
extends AddSchemaDefinitionCommand {
    public boolean _nullDefinitions;

    AddSchemaDefinitionCommand_20() {
    }

    AddSchemaDefinitionCommand_20(String definitionName) {
        super(definitionName);
    }

    AddSchemaDefinitionCommand_20(String definitionName, Object from) {
        super(definitionName, from);
    }

    @Override
    protected boolean defExists(OasDocument document) {
        Oas20Document doc20 = (Oas20Document)document;
        if (this.isNullOrUndefined(doc20.definitions)) {
            return false;
        }
        return !this.isNullOrUndefined(doc20.definitions.getDefinition(this._newDefinitionName));
    }

    @Override
    protected void prepareDocumentForDef(OasDocument document) {
        Oas20Document doc20 = (Oas20Document)document;
        if (this.isNullOrUndefined(doc20.definitions)) {
            doc20.definitions = doc20.createDefinitions();
            this._nullDefinitions = true;
        }
    }

    @Override
    protected OasSchema createSchemaDefinition(OasDocument document) {
        Oas20Document doc20 = (Oas20Document)document;
        Oas20SchemaDefinition definition = doc20.definitions.createSchemaDefinition(this._newDefinitionName);
        Library.readNode(this._newDefinitionObj, definition);
        return definition;
    }

    @Override
    protected void addDefinition(OasDocument document, OasSchema definition) {
        Oas20Document doc20 = (Oas20Document)document;
        Oas20SchemaDefinition def20 = (Oas20SchemaDefinition)definition;
        doc20.definitions.addDefinition(this._newDefinitionName, def20);
    }

    @Override
    protected void removeDefinition(OasDocument document) {
        Oas20Document doc20 = (Oas20Document)document;
        if (this._nullDefinitions) {
            doc20.definitions = null;
        } else {
            doc20.definitions.removeDefinition(this._newDefinitionName);
        }
    }
}

