/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.models.SimplifiedParameterType;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.core.models.common.Parameter;
import io.apicurio.datamodels.openapi.models.IOasParameterParent;
import io.apicurio.datamodels.openapi.models.OasParameter;

public abstract class ChangeParameterTypeCommand
extends AbstractCommand {
    public NodePath _paramPath;
    public SimplifiedParameterType _newType;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldParameter;

    ChangeParameterTypeCommand() {
    }

    ChangeParameterTypeCommand(Parameter parameter, SimplifiedParameterType newType) {
        this._paramPath = Library.createNodePath(parameter);
        this._newType = newType;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[ChangeParameterTypeCommand] Executing.", new Object[0]);
        Parameter param = (Parameter)this._paramPath.resolve(document);
        if (this.isNullOrUndefined(param)) {
            return;
        }
        this._oldParameter = Library.writeNode(param);
        this.doChangeParameter(document, param);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[ChangeParameterTypeCommand] Reverting.", new Object[0]);
        Parameter param = (Parameter)this._paramPath.resolve(document);
        if (this.isNullOrUndefined(param)) {
            return;
        }
        IOasParameterParent parent = (IOasParameterParent)((Object)param.parent());
        OasParameter oldParam = parent.createParameter();
        Library.readNode(this._oldParameter, oldParam);
        this.doRestoreParameter(param, oldParam);
    }

    protected abstract void doChangeParameter(Document var1, Parameter var2);

    protected abstract void doRestoreParameter(Parameter var1, Parameter var2);
}

