/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;

public class ChangeVersionCommand
extends AbstractCommand {
    public String _newVersion;
    public String _oldVersion;
    public boolean _nullInfo;

    ChangeVersionCommand() {
    }

    ChangeVersionCommand(String newVersion) {
        this._newVersion = newVersion;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[ChangeVersionCommand] Executing.", new Object[0]);
        if (ModelUtils.isNullOrUndefined(document.info)) {
            document.info = document.createInfo();
            this._nullInfo = true;
            this._oldVersion = null;
        } else {
            this._oldVersion = document.info.version;
        }
        document.info.version = this._newVersion;
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[ChangeVersionCommand] Reverting.", new Object[0]);
        if (this._nullInfo) {
            document.info = null;
        } else {
            document.info.version = this._oldVersion;
        }
    }
}

