/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.commands.AbstractSchemaInhCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;
import java.util.ArrayList;
import java.util.List;

public class DeleteAllChildSchemasCommand
extends AbstractSchemaInhCommand {
    public NodePath _schemaPath;
    public String _childSchemaType;
    @JsonDeserialize(contentUsing=MarshallCompat.NullableJsonNodeDeserializer.class)
    public List<Object> _oldSchemas;

    DeleteAllChildSchemasCommand() {
    }

    DeleteAllChildSchemasCommand(OasSchema parent, String type) {
        this._schemaPath = Library.createNodePath(parent);
        this._childSchemaType = type;
    }

    @Override
    public void execute(Document document) {
        Oas30Schema schema30;
        LoggerCompat.info("[DeleteAllChildSchemasCommand] Executing.", new Object[0]);
        this._oldSchemas = new ArrayList<Object>();
        OasSchema schema = (OasSchema)this._schemaPath.resolve(document);
        if (this.isNullOrUndefined(schema)) {
            return;
        }
        List<Object> schemas = new ArrayList();
        if (NodeCompat.equals("allOf", this._childSchemaType)) {
            schemas = schema.allOf;
            schema.allOf = new ArrayList<OasSchema>();
        }
        if (NodeCompat.equals("anyOf", this._childSchemaType)) {
            schema30 = (Oas30Schema)schema;
            schemas = schema30.anyOf;
            schema30.anyOf = new ArrayList<OasSchema>();
        }
        if (NodeCompat.equals("oneOf", this._childSchemaType)) {
            schema30 = (Oas30Schema)schema;
            schemas = schema30.oneOf;
            schema30.oneOf = new ArrayList<OasSchema>();
        }
        if (this.isNullOrUndefined(schemas)) {
            return;
        }
        this._oldSchemas = new ArrayList<Object>(schemas.size());
        schemas.forEach(oldSchema -> this._oldSchemas.add(Library.writeNode(oldSchema)));
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteAllChildSchemasCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldSchemas) || this._oldSchemas.size() == 0) {
            return;
        }
        OasSchema schema = (OasSchema)this._schemaPath.resolve(document);
        if (this.isNullOrUndefined(schema)) {
            return;
        }
        this.copySchemaJsTo(this._oldSchemas, schema, this._childSchemaType);
    }
}

