/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.models.OasSchema;
import java.util.ArrayList;
import java.util.List;

public class DeleteAllPropertiesCommand
extends AbstractCommand {
    public NodePath _schemaPath;
    @JsonDeserialize(contentUsing=MarshallCompat.NullableJsonNodeDeserializer.class)
    public List<Object> _oldProperties;

    DeleteAllPropertiesCommand() {
    }

    DeleteAllPropertiesCommand(OasSchema schema) {
        this._schemaPath = Library.createNodePath(schema);
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteAllPropertiesCommand] Executing.", new Object[0]);
        this._oldProperties = new ArrayList<Object>();
        OasSchema schema = (OasSchema)this._schemaPath.resolve(document);
        if (this.isNullOrUndefined(schema)) {
            return;
        }
        schema.getPropertyNames().forEach(pname -> {
            ObjectNode data = JsonCompat.objectNode();
            JsonCompat.setPropertyString(data, "name", pname);
            JsonCompat.setProperty(data, "schema", Library.writeNode(schema.removeProperty((String)pname)));
            JsonCompat.setPropertyBoolean(data, "required", this.isPropertyRequired(schema, (String)pname));
            this._oldProperties.add(data);
        });
        schema.required = null;
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteAllPropertiesCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldProperties) || this._oldProperties.size() == 0) {
            return;
        }
        OasSchema schema = (OasSchema)this._schemaPath.resolve(document);
        if (this.isNullOrUndefined(schema)) {
            return;
        }
        if (this.isNullOrUndefined(schema.required)) {
            schema.required = new ArrayList<String>();
        }
        this._oldProperties.forEach(oldProp -> {
            String name = JsonCompat.getPropertyString(oldProp, "name");
            Object schemaObj = JsonCompat.getProperty(oldProp, "schema");
            Boolean required = JsonCompat.getPropertyBoolean(oldProp, "required");
            OasSchema prop = schema.createPropertySchema(name);
            Library.readNode(schemaObj, prop);
            schema.addProperty(name, prop);
            if (ModelUtils.isDefined(required) && required == Boolean.TRUE) {
                schema.required.add(name);
            }
        });
    }

    private boolean isPropertyRequired(OasSchema schema, String propertyName) {
        return ModelUtils.isDefined(schema.required) && schema.required.indexOf(propertyName) != -1;
    }
}

