/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasPathItem;

public class NewPathCommand
extends AbstractCommand {
    public String _newPath;
    public boolean _pathExisted;
    public boolean _nullPaths;

    NewPathCommand() {
    }

    NewPathCommand(String newPath) {
        this._newPath = newPath;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[NewPathCommand] Executing.", new Object[0]);
        OasDocument odoc = (OasDocument)document;
        if (this.isNullOrUndefined(odoc.paths)) {
            odoc.paths = odoc.createPaths();
            this._nullPaths = true;
        }
        if (this.isNullOrUndefined(odoc.paths.getPathItem(this._newPath))) {
            OasPathItem pathItem = odoc.paths.createPathItem(this._newPath);
            odoc.paths.addPathItem(this._newPath, pathItem);
            this._pathExisted = false;
        } else {
            this._pathExisted = true;
        }
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[NewPathCommand] Reverting.", new Object[0]);
        OasDocument odoc = (OasDocument)document;
        if (this._pathExisted) {
            LoggerCompat.info("[NewPathCommand] path already existed, nothing done so no rollback necessary.", new Object[0]);
            return;
        }
        if (this._nullPaths) {
            LoggerCompat.info("[NewPathCommand] Paths was null, deleting it.", new Object[0]);
            odoc.paths = null;
        } else {
            LoggerCompat.info("[NewPathCommand] Removing a path item: %s", this._newPath);
            odoc.paths.removePathItem(this._newPath);
        }
    }
}

